import processing.core.*; 
import processing.xml.*; 

import oscP5.*; 
import netP5.*; 
import fullscreen.*; 
import sojamo.drop.*; 
import processing.video.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class betesnoires extends PApplet {


//._________________________________________________________.//
//|                                                         |//
//|            __?_____             ?                       |//
//|           /        \          ?      _______           /|//
//|  ___     /          \          ?    /       \         / |//
//| /   \___/            \          .--|O     O  \--.    /  |//
//|/                      \        /   |   V     /   \  /   |//
//|                        \      /     \_______/     \/    |//
//|                         \    /      /    \  \     /\    |//
//|__________________________\__/______/______\__\___/__\___|//




OscP5 oscP5;
NetAddress myRemoteLocation;

  
FullScreen fs; 




boolean recordOn=false;//enregistrer ?
MovieMaker mm;
boolean exportPNG=false;//enregistrer ?

PFont[] font=new PFont[4];

float curPos;

int sizx=600;
int sizy=500;

int phase=0;

int nbMonstres=40;//nombre de monstres dans le bestiaire

int nbLangues=2;
int langue=1;
int languePrev=langue;

String lettres = "abcdefghijklmnopqrstuvwxyz";
String consonnes = "bcdfghjklmnpqrstvwxz";
String voyelles = "aeiouy";

public void setup() {
  colorMode(HSB);
  size(sizx,sizy);
  smooth();
  frameRate(15);

  fs = new FullScreen(this); 

  if (recordOn) mm = new MovieMaker(this, width, height, "scene.mov", 30, MovieMaker.H263, MovieMaker.HIGH);

  oscP5 = new OscP5(this,12000);
  myRemoteLocation = new NetAddress("127.0.0.1",12001);
  oscP5.plug(this,"tic","/tic");
  oscP5.plug(this,"midiS","/midiS");  
  oscP5.plug(this,"sonPP5","/sonPP5");    

  chargePays();
  sendGeneral();

  font[0] = loadFont("BorisBlackBloxx-20.vlw");
  font[1] = loadFont("BorisBlackBloxx-30.vlw");  
  font[2] = loadFont("BorisBlackBloxx-40.vlw");  
  font[3] = loadFont("BorisBlackBloxx-50.vlw");  

  fondPopUp=new PImage(width,height);

  addMouseWheelListener(new java.awt.event.MouseWheelListener() {
    public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
      if (phase==3) {
        tempo+=evt.getWheelRotation();
        tempo=constrain(tempo,1,10);
      }
    }
  }
  );

  chargeBestiaire();
  chargeScene();
  changeLangue();  

  loadTheFile();

  setupIntro();
}

public void draw() {
  if (phase==0) {
    phaseA();
  }
  if (phase==1) {
    phaseB();
  }
  if (phase==2) {
    phaseC();
  }
  if (phase==3) {
    phaseD();
  }
  if (phase==4) {
    phaseE();
  }
  if (phase==5) {
    phaseF();
  }
  if (phase==6) {
    phaseG();
  }
  if (phase==7) {
    phaseH();
  }
  recordEv();
  if (languePrev!=langue) {
    changeLangue();  
    languePrev=langue;
  }
}

String message="";
int afficheMes=0;

public void recordEv() {
  if (afficheMes>0) {
    afficheMes--;
    noStroke();
    fill(0,192,192);
    textFont(font[2], (width+height)/30);
    textAlign(LEFT,CENTER);
    text(message, width/10, height/10); 
  }
}

public void stop() {
  saveTheFile();
  if (recordOn) {  
    mm.finish();
  }
}

PImage fondPopUp;

float debModelx=sizx*0.6f;//d\u00e9but du carr\u00e9 de l'interface x
float sizModel=sizx-debModelx-10;//taille de l'interface
float debModely=(sizy-sizModel)/2;//d\u00e9but du carr\u00e9 de l'interface y
float mCX=sizModel/2;// centre du mod\u00e8le en x
float mCY=sizModel/2;// centre du mod\u00e8le en y
float solModel=sizModel/2;//position du sol dans l'interface

float menuX=5;//taille du menu de gauche

float[] besDX = new float[nbMonstres];
float[] besDY = new float[nbMonstres];
float besTX;
float besTY;
float marBes=sizy/100;//marges entre les carr\u00e9s
float marBesGlo=marBes*2;//marges globales pour le bestiaire

int besCX=5;//nombre de carr\u00e9s en X
int besCY=ceil(nbMonstres/(float)besCX);//nombre de carr\u00e9s en Y

public void phaseB() {
  monstresFontPasChier();  
  recouvreB();
  //  monstreUnPeuPlusGros();
  phaseC(); 
  afficheBestiaire();  
  bestiaireMenu();  
  if (apercuvisible) {
    apercu();
  }    
}

public void recouvreB() {
  background(0);
}

public void chargeBestiaire() {
  besTX=(width-menuX-marBesGlo*2-(sizModel+10))/besCX;
  besTY=(height-marBesGlo*2)/besCY;
  for (int i=0;i<nbMonstres;i++) {
    besDX[i]=menuX+marBesGlo+besTX*(i%besCX);
    besDY[i]=besTY*floor(i/besCX)+marBesGlo;
  }
  moAE=-1;  
}

public void afficheBestiaire() {
  noStroke();
  for (int i=0;i<nbMonstres;i++) {
    if (monstre[i].sS==true) {
      fill(pays[paysC].teinte,150,150);
    }
    else {
      fill(pays[paysC].teinte,100,100);
    }
    rect(besDX[i]+marBes,besDY[i]+marBes,besTX-marBes*2,besTY-marBes*2);
  }
  int ind=souSurBes();
  if (ind!=-1) {
    if (monstre[ind].sS==true) {
      fill(pays[paysC].teinte,150,150);
    }
    else {
      fill(pays[paysC].teinte,100,100);
    }
    rect(besDX[ind]+marBes/2,besDY[ind]+marBes/2,besTX-marBes,besTY-marBes);
  }
  if (moAE!=-1) {
    if (monstre[moAE].sS==true) {
      fill(pays[paysC].teinte,150,150);
    }
    else{    
      fill(pays[paysC].teinte,100,100);
    }
    stroke(pays[paysC].teinte,100,200);
    rect(besDX[moAE],besDY[moAE],besTX,besTY);
    noStroke();
  } 
  for (int i=0;i<nbMonstres;i++) {
    if (monstre[i].taille>0.5f) {
      pushMatrix();
      translate(besDX[i]+besTX/2,besDY[i]+besTY/2);
      scale(besTX/(sizModel*1.5f));//1.5 pour laisser un peu de marge
      monstre[i].modelFixe();
      popMatrix();
    }
    else {
      pushMatrix();
      translate(besDX[i]+besTX/2,besDY[i]+besTY/2);
      scale(besTX/(sizModel*1.5f));//1.5 pour laisser un peu de marge
      fill(0);
      ellipse(0,0,sizModel/2,sizModel*2/3);
      popMatrix();
    }
  }
}

public int souSurBes() {
  int ind=-1;
  for (int i=0;i<nbMonstres;i++) {
    if (mouseX>besDX[i] && mouseX<besDX[i]+besTX && mouseY>besDY[i] && mouseY<besDY[i]+besTY) {
      ind=i;
    }
  }
  return ind;
}

public void bestiaireMenu() {
  if (moAE!=-1) {
    if (monstre[moAE].type!=0){
      if (monstre[moAE].sS==true) {
        if (langue==0) {
          besUtiliser.label="Retirer";
        }  
        if (langue==1) {
          besUtiliser.label="Remove";
        }          
      }
      else{
        if (langue==0) {
          besUtiliser.label="Inclure";
        }  
        if (langue==1) {
          besUtiliser.label="Add";
        }          
      }
      besUtiliser.teinte=(pays[paysC].teinte+32)%256;
      besUtiliser.dessine();     
    }
    if (monstre[moAE].type==0) {
      newA.teinte=(pays[paysC].teinte+32)%256;
      newB.teinte=(pays[paysC].teinte+32)%256;    
      newC.teinte=(pays[paysC].teinte+32)%256;    
      newR.teinte=(pays[paysC].teinte-32+256)%256;
      newA.dessine();
      newB.dessine();
      newC.dessine();
      newR.dessine();
    }
    else{
      besAurevoir.teinte=(pays[paysC].teinte+32)%256;
      besAurevoir.dessine();
    }
  }
  besPaysoner.teinte=(pays[paysC].teinte+32)%256;
  besPaysoner.dessine();
  besRemonter.dessine();
}

public void monstreUnPeuPlusGros() {
  float mUPPGDebY=310;
  anime();
  if (moAE!=-1) {
    monstre[moAE].pasRemue();
    noStroke();
    pushMatrix();
    translate(menuX/2,menuX/2+mUPPGDebY);
    fill(50,150,150);
    rect(marBes-menuX/2,marBes-menuX/2,menuX-marBes*2,menuX-marBes*2);
    scale(menuX/sizModel);
    float mXAR=(mouseX-menuX/2)/menuX*sizModel;//souris \u00e0 regarder X
    float mYAR=(mouseY-menuX/2-mUPPGDebY)/menuX*sizModel;//souris \u00e0 regarder Y
    monstre[moAE].regarde(mXAR,mYAR);
    monstre[moAE].model();
    popMatrix();
    fill(50,150,150);
    textFont(font[1], 30);
    textAlign(CENTER,CENTER);
    text(monstre[moAE].nom, menuX/2, 295);
  }
}

int nbMonSS;
int[] mSSN= new int[nbMonSS];

public void mAJmSSN() {
  int value=0;
  for (int i=0;i<nbMonstres;i++) {  
    if (monstre[i].sS==true) {
      value++;
    }
  }
  nbMonSS=value;
  int i2=0;
  int[] mSSNT= new int[nbMonSS];
  for (int i=0;i<nbMonstres;i++) {
    if (monstre[i].sS==true) {
      mSSNT[i2]=i;
      i2++;      
    }    
    if (monstre[i].type==2) {//j'en profite pour initier les mouvements des B \u00c3  ce moment l\u00c3 
      monstre[i].initMvts();
    }
  }
  mSSN= mSSNT;
}

int[] mPPlan=new int[3];//monstres par plans

public void placeAuto() {
  MAJSceneTaille();
  for (int i=0;i<3;i++) {
    mPPlan[i]=0;
  }
  for (int i=0;i<nbMonSS;i++) {
    mPPlan[monstre[mSSN[i]].plan]++;
  }
  int nbMPPlans=max(mPPlan[0],max(mPPlan[1],mPPlan[2]));//nombre de monstres max par plans
  int[] mPPlan2=new int[3];//monstres par plans  
  for (int i=0;i<nbMonSS;i++) {
    int planA=monstre[mSSN[i]].plan;
    monstre[mSSN[i]].y=sceDY+(sceLY*(3-planA))+(sceEY*((2-planA)))-(mCY*reducScene*monstre[mSSN[i]].taille);
    mPPlan2[planA]++;
    monstre[mSSN[i]].x=sceLX/(mPPlan[planA]+1)*mPPlan2[planA];
  }
}

float apeX=sizx/5;
float apeY=sizy/5;
float apeTX=sizx/5*3;
float apeTY=sizy/5*3;

public void apercu() {
  stroke(0);
  pushMatrix();
  translate(apeX,apeY);
  scale(apeTX/sceLX,apeTY/sceLTY);
  fill(pays[paysC].teinte,40,180);
  rect(0,sceDY,sceLX,sceLY);
  fill(pays[paysC].teinte,60,160);
  rect(0,sceDY+(sceLY+sceEY),sceLX,sceLY);
  //  teinteEau=lerpColor(color(pays[paysC].teinte,80,50), color(200,64,128), abs(tEau2-PI)/15);
  teinteEau=color(pays[paysC].teinte,40,64);
  fill(teinteEau);
  rect(0,sceDY+(sceLY+sceEY)*2,sceLX,sceLY); 
  popMatrix();  
  for (int i=0;i<nbMonSS;i++) {
    pushMatrix();
    translate(apeX+monstre[mSSN[i]].x*apeTX/sceLX,apeY+monstre[mSSN[i]].y*apeTY/sceLTY);
    scale(reducScene*monstre[mSSN[i]].taille);
    scale(apeTY/((sceLY+sceEY)*3),apeTY/((sceLY+sceEY)*3));
    monstre[mSSN[i]].modelFixe();
    popMatrix();
  }
}

public void sourisPhaseB() {
  moAE=souSurBes();
  if (moAE!=-1) {
    envoieSon(moAE);
  }
}

public void allerAuBestiaire() {
  cursor();    
  phase=1;
  sendGeneral();
}

public void monstresFontPasChier() {
  for (int i=0;i<nbMonstres;i++) {
    monstre[i].pasRemue();
    monstre[i].actEner=0;//enl\u00e8ve l'animation
    if (monstre[i].type==3) {
      for (int i2=0;i2<monstre[i].nbQueues;i2++) {
        monstre[i].queue[i2].pasBouge();
      }   
    }
    if (monstre[i].type==1) {        
      for (int i2=0;i2<monstre[i].nbTentacules;i2++) {
        monstre[i].tentacule[i2].pasBouge();
      }  
    }
  }      
}

class Boutons {
  float x;
  float y;
  float tX;
  float tY;
  float marge;
  float teinte;
  float lum1;
  float lum2;
  float sat1;
  float sat2;
  String label;
  float fontTaille;

  Boutons (float x, float y) {
    this.x=x;
    this.y=y;
    this.tX=10;
    this.tY=10;
    this.marge=5;
    this.teinte=50;
    this.lum1=100;
    this.lum2=150;
    this.sat1=100;
    this.sat2=150;
  }

  Boutons (String label,float x, float y, float tX, float tY, float marge, float teinte, float sat1, float sat2,float lum1, float lum2) {
    this.x=x;
    this.y=y;
    this.tX=tX;
    this.tY=tY;
    this.marge=marge;
    this.teinte=teinte;
    this.lum1=lum1;
    this.lum2=lum2;
    this.sat1=sat1;
    this.sat2=sat2;
    this.label=label;
    fontTaille=tY;
    fontTaille/=max(label.length()/(tX*1.5f/tY),1);
  }

  Boutons (String label,float x, float y, float tX, float tY, float marge, float teinte, float sat1, float sat2,float lum1, float lum2, float fontTaille) {
    this.x=x;
    this.y=y;
    this.tX=tX;
    this.tY=tY;
    this.marge=marge;
    this.teinte=teinte;
    this.lum1=lum1;
    this.lum2=lum2;
    this.sat1=sat1;
    this.sat2=sat2;
    this.label=label;
    this.fontTaille=fontTaille;
  }

  public void MAJFontSize() {
    fontTaille=tY;
    fontTaille/=max(label.length()/(tX*1.5f/tY),1);
  }

  public boolean actif() {
    if (mouseX>x && mouseX<x+tX && mouseY>y && mouseY<y+tY) {
      return true;
    }
    else {
      return false;
    }
  }  

  public void dessine() {
    noStroke();
    if (actif()==true) {
      fill(teinte,sat2,lum2);
      rect(x-marge,y-marge,tX+marge*2,tY+marge*2);      
    }
    else{
      fill(teinte,sat1,lum1);
      rect(x,y,tX,tY);

    }
    fill(0);
    int tF=0;
    if (fontTaille>25) {
      tF=1;      
    }
    if (fontTaille>35) {
      tF=2;      
    }
    if (fontTaille>45) {
      tF=3;      
    }    
    textFont(font[tF], fontTaille);
    textAlign(CENTER,CENTER);
    text(label, x+tX/2, y+tY/2);
  }

}

class MembresB{//d\u00e9fini sur un carr\u00e9 de 300/300
  int depend;//numero du monstre dont il d\u00e9pend
  float x;// x par rapport \u00e0 l'attache
  float y;// y par rapport \u00e0 l'attache
  int att;// index du corps d'attache
  float attX;
  float attY;
  float attR;
  public void setAttache() {
    this.attX=monstre[depend].corps[att].xR;
    this.attY=monstre[depend].corps[att].yR;
    this.attR=monstre[depend].corps[att].r;
  }
  public void relie(float xR,float yR,float attX,float attY,float r,float attR) {
    float inclin=atan2(yR-attY,xR-attX);
    beginShape();
    vertex(xR+(cos(inclin+HALF_PI)*r),yR+(sin(inclin+HALF_PI)*r));
    vertex(xR+(cos(inclin-HALF_PI)*r),yR+(sin(inclin-HALF_PI)*r));
    vertex(attX+(cos(inclin-HALF_PI)*attR),attY+(sin(inclin-HALF_PI)*attR));
    vertex(attX+(cos(inclin+HALF_PI)*attR),attY+(sin(inclin+HALF_PI)*attR));
    vertex(xR+(cos(inclin+HALF_PI)*r),yR+(sin(inclin+HALF_PI)*r));
    endShape();
  }
}

class Corps extends MembresB{
  float r;//rayon du cercle
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el

  float bougeT;
  float bougeF;  //force
  float bougeTPlus;  //increment de bougeT
  Corps(int depend, int att, float x, float y, float r) {
    this.depend=depend;
    this.att=att;
    this.x=x;
    this.y=y;
    this.r=r;
    bougeF=1;//force
    bougeTPlus=0.1f;
  }
  public void initMvts(int nb) {
    bougeF=1;//force
    bougeTPlus=0.1f;
    for (int i=0;i<monstre[depend].nbBecs;i++) {
      if (monstre[depend].bec[i].att==nb) {
        bougeF*=0.9f;
        bougeTPlus*=0.8f;
      }
    }
    for (int i=0;i<monstre[depend].nbYeux;i++) {
      if (monstre[depend].oeil[i].att==nb) {
        bougeF*=0.9f;
        bougeTPlus*=0.9f;        
      }
    }  
    for (int i=0;i<monstre[depend].nbCorps;i++) {
      if (monstre[depend].corps[i].att==nb) {
        bougeF*=0.8f;
        bougeTPlus*=0.8f;        
      }
    }
    for (int i=0;i<monstre[depend].nbJambes;i++) {
      if (monstre[depend].jambe[i].att==nb) {
        bougeF*=0.5f;
        bougeTPlus*=0.5f;
        int tmpAtt=att;
        for (int i2=0;i2<nbMembresMax;i2++) {
          monstre[depend].corps[tmpAtt].bougeF*=0.5f;
          monstre[depend].corps[tmpAtt].bougeTPlus*=0.5f;     
          tmpAtt=monstre[depend].corps[tmpAtt].att;
        }
      }
    }
  }
  public void agit() {
    bougeT=(bougeT+bougeTPlus)%TWO_PI;
  }
  public void dessine() {
    float actX=cos(0);
    float actY=sin(0);
    if (phase==3) {
      if (monstre[depend].samuse && monstre[depend].action==0) {
        float longu=longueur(x,y,0,0);
        float angl=atan2(y,x);
        xR=attX+longu*cos(angl+bougeF*cos(bougeT));
        yR=min(attY+longu*sin(angl+bougeF*cos(bougeT)),mCY/2-r);
      }
      else{
        xR=(xR+attX+x)/2;
        yR=(yR+attY+y)/2;        
      }
    }
    else {
      xR=attX+x;
      yR=attY+y;
    }
    ellipse(xR,yR,r*2,r*2);
    relie(xR,yR,attX,attY,r,attR);
  }
}

class Jambes extends MembresB{
  float xRT;//x r\u00e9el th\u00e9orique (sans le d\u00e9placement)
  float yRT;//y r\u00e9el th\u00e9orique (sans le d\u00e9placement)
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el
  float gX;//genouX
  float gY;//genouY
  float gXR;//genouX r\u00e9el
  float gYR;//genouY r\u00e9el
  float lJ;//longueur jambe (partie du bas)
  float radJam;//hauteur des jambes lors de la marche
  float angJam;//d\u00e9calage de phase entre les jambes
  float xPrec;//la position en x du pied le plus bas pr\u00e9c\u00e9dent
  float yEntree;

  Jambes(int depend, int att, float x,float y) {
    this.yEntree=y;
    this.depend=depend;
    this.att=att;
    this.y=solModel-monstre[depend].corps[att].yR;
    this.x=x;
    this.gX=x;
    this.gY=y;
    this.lJ=solModel-gY-monstre[depend].corps[att].yR;
  }
  public void agit(int i) {
    xPrec=xR;
    radJam=(sizModel/3)/monstre[depend].nbJambes;
    angJam=(TWO_PI/monstre[depend].nbJambes);
    xRT=attX+x;
    yRT=attY+y;
    float t2Spe=monstre[depend].t2*monstre[depend].nbJambes;
    if (monstre[depend].nbJambes==1) {//exception si juste une jambe
      radJam=sizModel/9;
      t2Spe=monstre[depend].t2*3;
    }
    xR=xRT+cos(t2Spe+i*angJam)*radJam*monstre[depend].actEner;
    yR=yRT+sin(t2Spe+i*angJam)*radJam*monstre[depend].actEner;
    gXR=attX+gX;
    gYR=yR-lJ;
    if (lJ<sizModel/10) {
      lJ+=sizModel/1000;
    }
  }
  public void dessine() {
    relie(gXR,gYR,attX,attY,attR/2,attR);
    ellipse(gXR,gYR,attR,attR);
    relie(xR,yR,gXR,gYR,0,attR/2);
  }
}

class Becs extends MembresB{
  float a;//angle
  float l;//longueur
  float o;//niveau d'ouverture (radians)
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el
  float[] ptx=new float[4];
  float[] pty=new float[4];
  Becs(int depend, int att, float x, float y) {
    this.depend=depend;    
    this.att=att;
    this.x=x;
    this.y=y;
    this.a=atan2(y,x);
    this.l=sqrt(sq(x)+sq(y));
  }
  public void agit(int i) {
    o=(o+(sin(t1+i*(TWO_PI/monstre[depend].nbBecs))+1)/3*monstre[depend].chante)/2;
  }
  public void dessine() {
    ptx[0]=attX+cos(a-HALF_PI)*attR;
    pty[0]=attY+sin(a-HALF_PI)*attR;
    ptx[1]=attX+cos(a+HALF_PI)*attR;
    pty[1]=attY+sin(a+HALF_PI)*attR;
    ptx[2]=attX+cos(a+o)*l;
    pty[2]=attY+sin(a+o)*l;
    ptx[3]=attX+cos(a-o)*l;
    pty[3]=attY+sin(a-o)*l;
    xR=(ptx[2]+ptx[3])/2;//indicatif
    yR=(pty[2]+pty[3])/2;//indicatif
    triangle(ptx[0],pty[0],ptx[1],pty[1],ptx[2],pty[2]);
    triangle(ptx[0],pty[0],ptx[1],pty[1],ptx[3],pty[3]);
  }
}

class Yeux extends MembresB{
  float r;//rayon du cercle
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el
  float regA;
  Yeux(int depend, int att, float x, float y, float r) {
    this.depend=depend;    
    this.att=att;
    this.x=x;
    this.y=y;
    this.r=r;
  }
  public void agit() {
    regA=atan2(monstre[depend].regardeY-yR,monstre[depend].regardeX-xR);
  }
  public void dessine() {
    xR=attX+x;
    yR=attY+y;
    ellipse(xR,yR,r*2,r*2);
    relie(xR,yR,attX,attY,r,attR);
  }
  public void dessinePupille() {
    ellipse(xR+cos(regA)*r/3,yR+sin(regA)*r/3,r,r);
  }
}

class MembresC {
  int depend;//monstre dont il depend
  int att;//vertebre \u00e0 laquelle il est rattach\u00e9
  float l;//longueur
  float corr;

  float vraiX1;
  float vraiX2;
  float vraiY1;
  float vraiY2;
  float angle;
  float bXR;
  float bYR;
  float gB1;//grosseur de la base
  float gB2;//grosseur de la base 
  float xR;
  float yR;

  public void defVraisD() {
    vraiX1=monstre[depend].xRVert2[max(att-1,0)];
    vraiX2=monstre[depend].xRVert2[min(att+1,nbVertebres-1)];
    vraiY1=monstre[depend].yRVert2[max(att-1,0)];
    vraiY2=monstre[depend].yRVert2[min(att+1,nbVertebres-1)];
    angle=atan2(vraiY2-vraiY1,vraiX2-vraiX1)-corr;
    bXR=monstre[depend].xRVert2[att];
    bYR=monstre[depend].yRVert2[att];
    gB1=longueur(vraiX1,vraiY1,bXR,bYR);//grosseur de la base
    gB2=longueur(bXR,bYR,vraiX2,vraiY2);//grosseur de la base
    xR=bXR+l*cos(angle+HALF_PI);
    yR=bYR+l*sin(angle+HALF_PI);   
  }
  public void defVraisG() {
    vraiX1=monstre[depend].xRVert[max(att-1,0)];
    vraiX2=monstre[depend].xRVert[min(att+1,nbVertebres-1)];
    vraiY1=monstre[depend].yRVert[max(att-1,0)];
    vraiY2=monstre[depend].yRVert[min(att+1,nbVertebres-1)];
    angle=atan2(vraiY2-vraiY1,vraiX2-vraiX1)+corr;
    bXR=monstre[depend].xRVert[att];
    bYR=monstre[depend].yRVert[att];
    gB1=longueur(vraiX1,vraiY1,bXR,bYR);//grosseur de la base
    gB2=longueur(bXR,bYR,vraiX2,vraiY2);//grosseur de la base    
    xR=bXR+l*cos(angle-HALF_PI);
    yR=bYR+l*sin(angle-HALF_PI);   
  }
}

class Pics extends MembresC {
  Pics(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
  }
  public void dessinePic() {
    float inclin=atan2(bYR-yR,bXR-xR);
    float r=(gB1+gB2)/2;
    beginShape();
    vertex(bXR+(cos(inclin+HALF_PI)*r),bYR+(sin(inclin+HALF_PI)*r));
    vertex(bXR+(cos(inclin-HALF_PI)*r),bYR+(sin(inclin-HALF_PI)*r));
    vertex(xR+(cos(inclin-HALF_PI)*(l/15)),yR+(sin(inclin-HALF_PI)*(l/15)));
    vertex(xR+(cos(inclin+HALF_PI)*(l/15)),yR+(sin(inclin+HALF_PI)*(l/15)));
    vertex(bXR+(cos(inclin+HALF_PI)*r),bYR+(sin(inclin+HALF_PI)*r));
    endShape();
    ellipse(bXR,bYR,r,r);
  }
  public void dessine() {
    defVraisD();
    dessinePic();
    defVraisG();
    dessinePic();
  }
}

class Queues extends MembresC {
  int nbBoules;
  float[] xBouD;
  float[] yBouD;
  float[] xBouG;
  float[] yBouG;
  Queues(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
    nbBoules=max(ceil(l*10/(sizModel/2)),1);
    xBouD=new float[nbBoules];
    yBouD=new float[nbBoules];
    xBouG=new float[nbBoules];
    yBouG=new float[nbBoules];    
    defVraisD();
    for(int i=0;i<nbBoules;i++) {
      xBouD[i]=bXR;
      xBouD[i]+=l*cos(angle+HALF_PI)*i/nbBoules;
      yBouD[i]=bYR;
      yBouD[i]+=l*sin(angle+HALF_PI)*i/nbBoules;
    }
    defVraisG();
    for(int i=0;i<nbBoules;i++) {
      xBouG[i]=bXR;
      xBouG[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBouG[i]=bYR;
      yBouG[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }    
  }
  public void dessine() {
    for(int i=0;i<nbBoules;i++) {
      ellipse(xBouD[i],yBouD[i],l/nbBoules,l/nbBoules);
      ellipse(xBouG[i],yBouG[i],l/nbBoules,l/nbBoules);      
    }
  }
  public void pasBouge() {
    defVraisD();
    for(int i=0;i<nbBoules;i++) {
      xBouD[i]=bXR;
      xBouD[i]+=l*cos(angle+HALF_PI)*i/nbBoules;
      yBouD[i]=bYR;
      yBouD[i]+=l*sin(angle+HALF_PI)*i/nbBoules;
    }
    defVraisG();
    for(int i=0;i<nbBoules;i++) {
      xBouG[i]=bXR;
      xBouG[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBouG[i]=bYR;
      yBouG[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }    
  }  
  public void agit() {
    defVraisD();
    xBouD[0]=bXR;
    yBouD[0]=bYR;
    for(int i=1;i<nbBoules;i++) {
      float aTmp=atan2(yBouD[i]-yBouD[i-1],xBouD[i]-xBouD[i-1]);
      xBouD[i]=xBouD[i-1]+cos(aTmp)*l/nbBoules;
      yBouD[i]=yBouD[i-1]+sin(aTmp)*l/nbBoules;
    }
    defVraisG();    
    xBouG[0]=bXR;
    yBouG[0]=bYR;
    for(int i=1;i<nbBoules;i++) {
      float aTmp=atan2(yBouG[i]-yBouG[i-1],xBouG[i]-xBouG[i-1]);
      xBouG[i]=xBouG[i-1]+cos(aTmp)*l/nbBoules;
      yBouG[i]=yBouG[i-1]+sin(aTmp)*l/nbBoules;
    }    
  }
}

class Ailes extends MembresC {
  Ailes(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
  }
  public void dessinePic() {
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    vertex(xR,yR);
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);    
  }
  public void dessine() {
    defVraisD();
    dessinePic();
    defVraisG();
    dessinePic();
  }
}

class YeuxC extends MembresC {
  float regAD;
  float regAG;  
  YeuxC(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
  }
  public void agit() {
    defVraisD();    
    regAD=atan2(monstre[depend].regardeY-yR,monstre[depend].regardeX-xR);
    defVraisG();    
    regAG=atan2(monstre[depend].regardeY-yR,monstre[depend].regardeX-xR);    
  }
  public void dessinePic() {
    ellipse(xR,yR,l/5+6,l/5+6);
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    vertex(xR,yR);
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);    
  }
  public void dessine() {
    defVraisD();
    dessinePic();
    defVraisG();
    dessinePic();
  }
  public void dessinePupille() {
    defVraisD();
    ellipse(xR+cos(regAD)*l/20,yR+sin(regAD)*l/20,l/7+3,l/7+3);
    defVraisG();
    ellipse(xR+cos(regAG)*l/20,yR+sin(regAG)*l/20,l/7+3,l/7+3);
  }
}

class MembresA {
  int depend;//monstre dont il depend
  int att;//bourse \u00e0 laquelle il est rattach\u00e9
  float l;//longueur
  float corr;

  float vraiX1;
  float vraiY1;
  float vraiX2;
  float vraiY2;
  float angle;
  float bXR;
  float bYR;
  float gB1;//grosseur de la base
  float gB2;//grosseur de la base  

  public void defVrais() {
    vraiX1=monstre[depend].xRBour[(att-1+nbBourses)%nbBourses];
    vraiY1=monstre[depend].yRBour[(att-1+nbBourses)%nbBourses];
    vraiX2=monstre[depend].xRBour[(att+1)%nbBourses];
    vraiY2=monstre[depend].yRBour[(att+1)%nbBourses];
    angle=atan2(vraiY2-vraiY1,vraiX2-vraiX1)+corr;
    bXR=monstre[depend].xRBour[att];
    bYR=monstre[depend].yRBour[att];
    gB1=longueur(vraiX1,vraiY1,bXR,bYR);//grosseur de la base
    gB2=longueur(bXR,bYR,vraiX2,vraiY2);//grosseur de la base    
  }
}

class Cils extends MembresA {
  Cils(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;  
  }
  public void dessine() {
    defVrais();
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    vertex(bXR+l*cos(angle-HALF_PI),bYR+l*sin(angle-HALF_PI));
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);
  }
}

class Tentacules extends MembresA {
  int nbBoules;
  float[] xBou;
  float[] yBou;
  Tentacules(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
    nbBoules=max(ceil(l*10/(sizModel/2)),1);
    xBou=new float[nbBoules];
    yBou=new float[nbBoules];
    defVrais();
    for(int i=0;i<nbBoules;i++) {
      xBou[i]=bXR;
      xBou[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBou[i]=bYR;
      yBou[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }
  }
  public void dessine() {
    defVrais();
    for(int i=0;i<nbBoules;i++) {
      ellipse(xBou[i],yBou[i],l/nbBoules,l/nbBoules);
    }
  }
  public void pasBouge() {
    defVrais();
    for(int i=0;i<nbBoules;i++) {
      xBou[i]=bXR;
      xBou[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBou[i]=bYR;
      yBou[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }
  }  
  public void agit() {
    xBou[0]=bXR;
    yBou[0]=bYR;
    for(int i=1;i<nbBoules;i++) {
      float prevyBou=yBou[i];
      yBou[i]+=(sin(monstre[depend].prevtPosY)-sin(monstre[depend].tPosY))*100;
      yBou[i]+=3;
      xBou[i]*=max((prevyBou-yBou[i])/10,1);
      float aTmp=atan2(yBou[i]-yBou[i-1],xBou[i]-xBou[i-1]);
      xBou[i]=xBou[i-1]+cos(aTmp)*l/nbBoules;
      yBou[i]=yBou[i-1]+sin(aTmp)*l/nbBoules;
    }    
  }  
}

class Bras extends MembresA {
  int nbDiv;
  float t=0;
  Bras(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;  
    this.nbDiv=floor(l*50/sizModel)+1;
  }
  public void pasBouge() {
  }  
  public void agit() {
    t+=0.1f;
    t=t%TWO_PI;
  }  
  public void dessine() {
    defVrais();
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    for (int i=0;i<nbDiv;i++) {
      float coeff=((float)i)/((float)nbDiv);
      float coeff2=1-abs(coeff-0.5f);
      float x=(bXR+l*cos(angle-HALF_PI))*coeff;
      x+=vraiX2*(1-coeff);
      x+=cos(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;      //anim
      float y=(bYR+l*sin(angle-HALF_PI))*coeff;
      y+=vraiY2*(1-coeff);
      y+=sin(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;      //anim
      vertex(x,y);
    }
    vertex(bXR+l*cos(angle-HALF_PI),bYR+l*sin(angle-HALF_PI));
    for (int i=nbDiv-1;i>=0;i--) {
      float coeff=((float)i)/((float)nbDiv);
      float coeff2=1-abs(coeff-0.5f);
      float x=(bXR+l*cos(angle-HALF_PI))*coeff;
      x+=vraiX1*(1-coeff);
      x+=cos(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;            //anim
      float y=(bYR+l*sin(angle-HALF_PI))*coeff;
      y+=vraiY1*(1-coeff);
      y+=sin(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;            //anim
      vertex(x,y);
    }    
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);
  }
}

class YeuxA extends MembresA {
  float xGlobe;
  float yGlobe;
  float regA;
  YeuxA(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;  
  }
  public void agit() {
    regA=atan2(monstre[depend].regardeY-yGlobe,monstre[depend].regardeX-xGlobe);
  }  
  public void dessine() {
    defVrais();
    xGlobe=bXR+(l/2)*cos(angle-HALF_PI);
    yGlobe=bYR+(l/2)*sin(angle-HALF_PI);
    triangle(0,0,xGlobe+(l/2)*cos(angle),yGlobe+(l/2)*sin(angle),xGlobe+(l/2)*cos(angle+PI),yGlobe+(l/2)*sin(angle+PI));
    float r=max(l,sizModel/10);
    ellipse(xGlobe,yGlobe,r,r);
  }
  public void dessinePupille() {
    float r=max(l,sizModel/10);    
    ellipse(bXR+l/2*cos(angle-HALF_PI)+cos(regA)*l/6,bYR+l/2*sin(angle-HALF_PI)+sin(regA)*l/6,r*1/3,r*1/3);
  }
}

Monstres[] monstre=new Monstres[nbMonstres];

int nbMembresMax=10;//longueur des tableaux de membres
int nbBourses=30;
int nbVertebres=30;

float tailleMax=5;
float tOeuf=0.5f;

class Monstres {
  int type;//0=mort 1=A 2=B 3=C
  String nom="";
  int plan;
  // sur le moment
  float x;
  float y;
  float regardeX;
  float regardeY;
  int action;
  float actEner=0;//enveloppe de l'action
  // actions :
  // 0 = rien
  // 1 = droite
  // 2 = gauche
  float t2=0;//pour les jambes
  float taille=1;//multiplicateur de taille
  float espVie=1000;//esp\u00e9rance de vie
  int nb;
  int tmpDecision;
  boolean sS;//sur sc\u00e8ne ou pas
  float gestation=200;

  //propri\u00e9t\u00e9s monstre A
  int nbCils;//nombre de tentacules
  int nbTentacules;//nombre de tentacules
  int nbBras;//nombre de tentacules
  int nbYeuxA;//nombre de tentacules  
  Cils[] cil = new Cils[nbMembresMax];
  Tentacules[] tentacule = new Tentacules[nbMembresMax];
  Bras[] bras = new Bras[nbMembresMax];  
  YeuxA[] oeilA = new YeuxA[nbMembresMax];
  float[] bourseL = new float[nbBourses];
  float[] bourseR = new float[nbBourses];
  float tA;//timer pour monstre A
  float[] bougeL = new float[nbBourses];
  float[] xRBour = new float[nbBourses];//x r\u00e9el d'une bourse
  float[] yRBour = new float[nbBourses];//y r\u00e9el d'une bourse
  float tPosY = 0;
  float prevtPosY;

  //propri\u00e9t\u00e9s monstre B
  int nbCorps;//nombre de corps
  int nbJambes;//nombre de jambes
  int nbYeux;//nombre d'yeux
  int nbBecs;//nombre de becs
  Corps[] corps = new Corps[nbMembresMax];
  Jambes[] jambe = new Jambes[nbMembresMax];
  Yeux[] oeil = new Yeux[nbMembresMax];
  Becs[] bec = new Becs[nbMembresMax];
  int nbPPlusBas;//le pied le plus bas
  int nbPPlusBasPrev;//le pied le plus bas
  boolean samuse=true;

  //propri\u00e9t\u00e9s monstre C
  int nbPics;//nombre de corps
  int nbQueues;//nombre de corps
  int nbAiles;//nombre de corps
  int nbYeuxC;//nombre de corps  
  Pics[] pic = new Pics[nbMembresMax];
  Queues[] queue = new Queues[nbMembresMax];  
  Ailes[] aile = new Ailes[nbMembresMax];  
  YeuxC[] oeilC = new YeuxC[nbMembresMax];  
  float[] xRVert = new float[nbVertebres];//x r\u00e9el d'une vertebre
  float[] yRVert = new float[nbVertebres];//y r\u00e9el d'une vertebre
  float[] xRVert2 = new float[nbVertebres];//x r\u00e9el d'une vertebre
  float[] yRVert2 = new float[nbVertebres];//y r\u00e9el d'une vertebre
  float[] gVert = new float[nbVertebres];//grosseur d'une vertebre
  float[] cVert = new float[nbVertebres];//compression d'une vertebre
  float[] xVert = new float[nbVertebres];//d\u00e9calage d'une vertebre en x
  float[] yVert = new float[nbVertebres];//d\u00e9calage d'une vertebre en y
  float[] aVert = new float[nbVertebres];//angle d'une vertebre
  float tC;//timer pour cVert[]
  float tR;//timer pour xVert[] et yVert[]  

  float chante=0;

  boolean dansLoeuf=false;

  public void pasRemue() {
  }

  public void nomAleat() {
    boolean voy=true;
    if (random(100)<50) {
      voy=false;
    }
    int lettreEP;
    if (voy) {
      lettreEP=floor(random(0,voyelles.length()));
      nom=voyelles.substring(lettreEP,lettreEP+1);
      voy=false;
    }
    else{
      lettreEP=floor(random(0,consonnes.length()));
      nom=consonnes.substring(lettreEP,lettreEP+1);      
      voy=true;
    }
    nom=nom.toUpperCase();
    while (random(100)<100-nom.length()*10) {
      if (voy) {
        lettreEP=floor(random(0,voyelles.length()));
        nom+=voyelles.substring(lettreEP,lettreEP+1);
        voy=false;
      }
      else{
        lettreEP=floor(random(0,consonnes.length()));
        nom+=consonnes.substring(lettreEP,lettreEP+1);
        voy=true;
      }
    }
  }

  public void decision() {
    tmpDecision--;
    if (tmpDecision<0) {//alors d\u00e9cide
      tmpDecision=500;
      action++;
      if (action==3) {
        action=0;
        if (samuse) {
          samuse=false;          
        }
        else{
          samuse=true;
        }
      }
    }
    if (x>sceLX) {
      action=2;
    }
    if (x<0) {
      action=1;
    }
    boolean tousFixes=true;
    for (int i=0;i<nbMonSS;i++) {
      if (monstre[mSSN[i]].action!=0) {
        tousFixes=false;
      }
    }
    if (tousFixes) {
      action=2;
    }
  }
  public void antiSimil( int nb2) {
  }

  public void rencontre() {
    for (int i=0;i<nbMonSS;i++) {
      if (mSSN[i]!=nb) {
        if (abs(monstre[mSSN[i]].x-x)<5) {
          if (monstre[mSSN[i]].type==type) {
            antiSimil(mSSN[i]);
            if (abs(monstre[mSSN[i]].taille-taille)<0.45f && taille>tOeuf && monstre[mSSN[i]].taille>tOeuf) {//s'ils ont presque la m\u00eame taille et qu'aucun n'est un oeuf
              int monstresSurCePlan=0;
              for (int i2=0;i2<nbMonSS;i2++) {
                if (monstre[mSSN[i2]].type==type){
                  monstresSurCePlan++;
                }
              }
              if (monstresSurCePlan<=nbMonstres/3) {            
                if (gestation<=0) {            
                  hybride(nb,monstre[mSSN[i]].nb);//ils se reproduisent
                  gestation=taille*100;
                  monstre[mSSN[i]].gestation=monstre[mSSN[i]].taille*100;
                }
              }
            }
            else if (abs(monstre[mSSN[i]].taille-taille)<2 && taille>tOeuf && monstre[mSSN[i]].taille>tOeuf) {//s'ils ont une taille diff\u00e9rente et qu'aucun n'est un oeuf
              int monstresSurCePlan=0;
              for (int i2=0;i2<nbMonSS;i2++) {
                if (monstre[mSSN[i2]].type==type){
                  monstresSurCePlan++;
                }
              }
              if (monstresSurCePlan>3) {
                if (gestation<=0) {
                  fight(nb,monstre[mSSN[i]].nb);//ils se battent
                  gestation=taille*100;
                  monstre[mSSN[i]].gestation=monstre[mSSN[i]].taille*100;
                }
              }
            } 
            else {//s'ils ont une taille vraiment trop diff\u00e9rente
              //le plus petit fuit
            }
          }
        }
      }
    }
  }

  public void initMvts() {
  }

  public void vit() {
    chante=max(chante-0.04f,0);
    if (action!=0) {
      gestation--;
    }
    if (taille<tailleMax) {
      taille+=0.001f;      
    }
    espVie--;
    if (espVie<=0) {// mort !
      monstre[nb]=new MonstresMorts(nb);
    }
  }

  public void regardMProche() {
    float longueurMin=width;
    int mPProche=-1;
    for (int i=0;i<nbMonSS;i++) {
      if (mSSN[i]!=nb) {
        if(longueur(monstre[mSSN[i]].x,monstre[mSSN[i]].y,x,y)<longueurMin) {
          longueurMin=longueur(monstre[mSSN[i]].x,monstre[mSSN[i]].y,x,y);
          mPProche=mSSN[i];
        }
      }
    }
    if (mPProche!=-1) {
      regarde((regardeX+monstre[mPProche].x-x)/2,(regardeY+monstre[mPProche].y-y)/2);
    }
  }

  public void regarde(float rX, float rY) {
    regardeX=rX;
    regardeY=rY;
  }

  public void model() {// dessine le prototype en grand plan
  }  
  public void modelFixe() {  
  }  
  public void agitFaible() {// se fait aussi dans le bestiaire
  }
  public void agit() {// autres membres actifs
  }       
  public void deplace() {// au niveau des jambes
  }

}

class MonstresMorts extends Monstres {
  MonstresMorts(int nb) {
    type=0;
    action=0;
    this.nb=nb;
    nom="";
    this.sS=false;
  }
  public void model() {// dessine le prototype en grand plan
  }  
  public void modelFixe() {  
  }  
  public void agit() {// autres membres actifs
  }       
  public void deplace() {// au niveau des jambes
  }
}


class MonstresA extends Monstres {//sous-sol

  MonstresA(int nb) {
    type=1;
    plan=type-1;    
    action=0;
    this.nb=nb;
    for (int i=0;i<nbBourses;i++) {
      bourseL[i]=sizModel/8;
      bourseR[i]=TWO_PI*i/nbBourses;
    }
    nom="";
  }

  public void antiSimil(int nb2) {
    for (int i=0;i<nbCils;i++) {
      if (i<monstre[nb2].nbCils) {
        if (monstre[nb2].cil[i].l==cil[i].l) {
          espVie-=1;
        }
      }
    }
    for (int i=0;i<nbTentacules;i++) {
      if (i<monstre[nb2].nbTentacules) {
        if (monstre[nb2].tentacule[i].l==tentacule[i].l) {
          espVie-=1;
        }
      }
    }    
    for (int i=0;i<nbBras;i++) {
      if (i<monstre[nb2].nbBras) {
        if (monstre[nb2].bras[i].l==bras[i].l) {
          espVie-=1;
        }
      }
    }    
    for (int i=0;i<nbYeuxA;i++) {
      if (i<monstre[nb2].nbYeuxA) {
        if (monstre[nb2].oeilA[i].l==oeilA[i].l) {
          espVie-=1;
        }
      }
    }
  }

  public void decision() {
    tmpDecision--;
    if (tmpDecision<0) {//alors d\u00e9cide
      tmpDecision=100+(nbCils+nbTentacules+nbBras+nbYeuxA)*100;
      action++;
      if (action==3) {
        action=0;
      }
    }
    if (x>sceLX*0.95f) {
      action=2;
    }
    if (x<sceLX*0.05f) {
      action=1;
    }
    boolean tousFixes=true;
    for (int i=0;i<nbMonSS;i++) {
      if (monstre[mSSN[i]].action!=0) {
        tousFixes=false;
      }
    }
    if (tousFixes) {
      action=2;
    }    
  }

  public void deplace() {
    if (action==0) {
      actEner=constrain(actEner-0.1f,0,1);
    }
    if (action==1 || action==2) {
      actEner=constrain(actEner+0.1f,0,1);
    }
    if (anime==true) {
      if (action==1) {
        x+=taille*actEner;
      }
      if (action==2) {
        x-=taille*actEner;
      }
    }
    prevtPosY=tPosY;
    tPosY=(tPosY+(tailleMax-taille)/(tailleMax*5))%TWO_PI;//d\u00e9place verticalement
    y=sceDY+(sceLY*2.5f)+(sceEY*2)+sin(tPosY)*(sceLY*min(taille,1)/4);
  }

  public void pasRemue() {
    for (int i=0;i<nbBourses;i++) {
      bougeL[i]=1;
    }
    for (int i=0;i<nbTentacules;i++) {
      tentacule[i].pasBouge();
    } 
  }

  public void model() {// dessine le prototype en grand plan
    fill(0);
    noStroke();
    beginShape();
    for (int i=0;i<nbBourses;i++) {
      xRBour[i]=bourseL[i]*bougeL[i]*cos(bourseR[i]);
      yRBour[i]=bourseL[i]*bougeL[i]*sin(bourseR[i]);
      curveVertex(xRBour[i],yRBour[i]);
    }
    curveVertex(xRBour[0],yRBour[0]);
    curveVertex(xRBour[1],yRBour[1]);
    curveVertex(xRBour[2],yRBour[2]);
    endShape();
    for (int i=0;i<nbCils;i++) {
      cil[i].dessine();
    }
    for (int i=0;i<nbTentacules;i++) {
      tentacule[i].dessine();
    }
    for (int i=0;i<nbBras;i++) {
      bras[i].dessine();
    }
    for (int i=0;i<nbYeuxA;i++) {
      oeilA[i].dessine();
    }
    fill(255);
    for (int i=0;i<nbYeuxA;i++) {
      oeilA[i].dessinePupille();
    }   
  }

  public void modelFixe() {
    fill(0);
    noStroke();
    beginShape();
    for (int i=0;i<nbBourses;i++) {
      xRBour[i]=bourseL[i]*cos(bourseR[i]);
      yRBour[i]=bourseL[i]*sin(bourseR[i]);
      curveVertex(xRBour[i],yRBour[i]);
    }
    curveVertex(xRBour[0],yRBour[0]);
    curveVertex(xRBour[1],yRBour[1]);
    curveVertex(xRBour[2],yRBour[2]);
    endShape();
    for (int i=0;i<nbCils;i++) {
      cil[i].dessine();
    }
    for (int i=0;i<nbTentacules;i++) {
      tentacule[i].dessine();
    }
    for (int i=0;i<nbBras;i++) {
      bras[i].dessine();
    }
    for (int i=0;i<nbYeuxA;i++) {
      oeilA[i].dessine();
    }
    fill(255);
    for (int i=0;i<nbYeuxA;i++) {
      oeilA[i].dessinePupille();
    }    
  }  

  public void agitFaible() {// se fait aussi dans le bestiaire
    for (int i=0;i<nbYeuxA;i++) {
      oeilA[i].agit();
    }
      for (int i=0;i<nbBras;i++) {
        bras[i].agit();
      }    
  }

  public void agit() {// autres membres actifs
    tA=(tA+0.05f)%TWO_PI;
    for (int i=0;i<nbBourses;i++) {
      bougeL[i]=sin(tA+TWO_PI*i/nbBourses)/2+1;
    }
    if (anime==true) {
      for (int i=0;i<nbTentacules;i++) {
        tentacule[i].agit();
      }
      for (int i=0;i<nbYeuxA;i++) {
        oeilA[i].agit();
      }
      for (int i=0;i<nbBras;i++) {
        bras[i].agit();
      }
    }
  }       

}


class MonstresB extends Monstres {//terre

  MonstresB(int nb) {
    type=2;
    plan=type-1;    
    nbCorps=1;//nombre de corps
    nbJambes=0;//nombre de jambes
    nbYeux=0;//nombre d'yeux
    nbBecs=0;//nombre de becs
    //pr\u00e9pare le premier corps
    Corps tmpCorps=new Corps(nb,0,0,0,20);
    corps[0]=tmpCorps;
    action=0;
    this.nb=nb;
    nom="";    
  }

  public void initMvts() {
    for (int i=0;i<nbCorps;i++) {
      corps[i].initMvts(i);
    }
  }

  public void antiSimil(int nb2) {
    for (int i=0;i<nbCorps;i++) {
      if (i<monstre[nb2].nbCorps) {
        if (monstre[nb2].corps[i].xR==corps[i].xR) {
          espVie-=1;
        }
      }
    }
    for (int i=0;i<nbJambes;i++) {
      if (i<monstre[nb2].nbJambes) {
        if (monstre[nb2].jambe[i].xR==jambe[i].xR) {
          espVie-=1;
        }
      }
    }    
    for (int i=0;i<nbBecs;i++) {
      if (i<monstre[nb2].nbBecs) {
        if (monstre[nb2].bec[i].xR==bec[i].xR) {
          espVie-=1;
        }
      }
    }    
    for (int i=0;i<nbYeux;i++) {
      if (i<monstre[nb2].nbYeux) {
        if (monstre[nb2].oeil[i].xR==oeil[i].xR) {
          espVie-=1;
        }
      }
    }
  }

  public void decision() {
    tmpDecision--;
    if (tmpDecision<0) {//alors d\u00e9cide
      tmpDecision=(nbCorps+nbJambes+nbBecs+nbYeux)*100;
      action++;
      if (action==3) {
        action=0;
        if (samuse) {
          samuse=false;          
        }
        else{
          samuse=true;
        }        
      }
    }
    if (x>sceLX*0.95f) {
      action=2;
    }
    if (x<sceLX*0.05f) {
      action=1;
    }
    boolean tousFixes=true;
    for (int i=0;i<nbMonSS;i++) {
      if (monstre[mSSN[i]].action!=0) {
        tousFixes=false;
      }
    }
    if (tousFixes) {
      action=2;
    }    
  }

  public void deplace() {// au niveau des jambes
    if (taille>=tOeuf) {
      if (action==0) {
        actEner=constrain(actEner-0.1f,0,1);
      }
      if (action==1 || action==2) {
        actEner=constrain(actEner+0.1f,0,1);
      }    
      if (anime==true) {
        if (action==1) {
          t2+=0.05f;
          t2=(t2+TWO_PI)%TWO_PI;
        }
        if (action==2) {
          t2-=0.05f;
          t2=(t2+TWO_PI)%TWO_PI;
        }
      }
      //fait mouvoir les jambes
      for (int i=0;i<nbJambes;i++) {
        jambe[i].agit(i);
      }
      //replace sur le sol
      float pPlusBas=y-planSol[plan];
      boolean genou=false;
      for (int i=0;i<nbJambes;i++) {
        float piedYSurplus=(y+jambe[i].yR*(reducScene*taille))-planSol[plan];
        float genouYSurplus=(y+(jambe[i].gYR+jambe[i].attR/2)*(reducScene*taille))-planSol[plan];       
        if (piedYSurplus>pPlusBas) {
          pPlusBas=piedYSurplus;
          nbPPlusBas=i;
          genou=false;
        }
        if (genouYSurplus>pPlusBas) {
          pPlusBas=genouYSurplus;
          nbPPlusBas=i;
          genou=true;
        }        
      }
      if (nbPPlusBas!=nbPPlusBasPrev) {
        if (x>camPos && x<camPos+width) {
          pasOn=true;
          quiPas=nb;
        }
      }
      if (nbJambes>0) { 
        if (action==1) {
          x+=max((jambe[nbPPlusBas].xPrec-jambe[nbPPlusBas].xR)*(reducScene*taille),0);
        }
        if (action==2) {
          x+=min((jambe[nbPPlusBas].xPrec-jambe[nbPPlusBas].xR)*(reducScene*taille),0);
        }
        if (action==0) {
          x+=(jambe[nbPPlusBas].xPrec-jambe[nbPPlusBas].xR)*(reducScene*taille);
        }   
      }
      else{
        pPlusBas=-sizModel*tailleMax;
        for (int i=0;i<nbCorps;i++) {
          float vraivraiY=(y+(corps[i].yR+corps[i].r)*(reducScene*taille))-planSol[plan];
          if (vraivraiY>pPlusBas) {
            pPlusBas=vraivraiY;
          }
        }
        for (int i=0;i<nbBecs;i++) {
          float vraivraiY=(y+(bec[i].yR)*(reducScene*taille))-planSol[plan];
          if (vraivraiY>pPlusBas) {
            pPlusBas=vraivraiY;
          }
        }
        for (int i=0;i<nbYeux;i++) {
          float vraivraiY=(y+(oeil[i].yR+oeil[i].r)*(reducScene*taille))-planSol[plan];
          if (vraivraiY>pPlusBas) {
            pPlusBas=vraivraiY;
          }
        }        
      }
      nbPPlusBasPrev=nbPPlusBas;
      y-=pPlusBas;
    }
    else{
      y=(y+planSol[1]-(sizModel/3*reducScene))/2;
    }
  }

  public void agitFaible() {// se fait aussi dans le bestiaire
    for (int i=0;i<nbYeux;i++) {
      oeil[i].agit();
    }  
  }

  public void agit() {// autres membres actifs
    if (anime==true) {
      if (phase==3){
        for (int i=0;i<nbCorps;i++) {
          corps[i].agit();
        }
      }
      for (int i=0;i<nbBecs;i++) {
        bec[i].agit(i);
      }
      for (int i=0;i<nbJambes;i++) {
        jambe[i].agit(i);
      }
      for (int i=0;i<nbYeux;i++) {
        oeil[i].agit();
      }
    }
  }

  public void modelFixe() {
    float tmpT=t1;
    t1=0;
    agit();
    model();
    t1=tmpT;
  }

  public void model() {// dessine le prototype en grand plan
    fill(0);
    for (int i=0;i<nbCorps;i++) {
      corps[i].setAttache();
      corps[i].dessine();
    }
    for (int i=0;i<nbBecs;i++) {
      bec[i].setAttache();      
      bec[i].dessine();
    }
    for (int i=0;i<nbJambes;i++) {
      jambe[i].setAttache();      
      jambe[i].dessine();
    }
    for (int i=0;i<nbYeux;i++) {
      oeil[i].setAttache();      
      oeil[i].dessine();
    }
    fill(255);
    for (int i=0;i<nbYeux;i++) {
      oeil[i].dessinePupille();
    }
  }
}


class MonstresC extends Monstres {//ciel

  MonstresC(int nb) {
    type=3;
    plan=type-1;
    action=0;
    this.nb=nb;
    for (int i=0;i<nbVertebres;i++) {
      gVert[i]=nbVertebres/2-abs(i-(nbVertebres/2));
    }
    nom="";
  }

  public void antiSimil(int nb2) {
    for (int i=0;i<nbPics;i++) {
      if (i<monstre[nb2].nbPics) {
        if (monstre[nb2].pic[i].l==pic[i].l) {
          espVie-=1;
        }
      }
    }
    for (int i=0;i<nbQueues;i++) {
      if (i<monstre[nb2].nbQueues) {
        if (monstre[nb2].queue[i].l==queue[i].l) {
          espVie-=1;
        }
      }
    }    
    for (int i=0;i<nbAiles;i++) {
      if (i<monstre[nb2].nbAiles) {
        if (monstre[nb2].aile[i].l==aile[i].l) {
          espVie-=1;
        }
      }
    }    
    for (int i=0;i<nbYeuxC;i++) {
      if (i<monstre[nb2].nbYeuxC) {
        if (monstre[nb2].oeilC[i].l==oeilC[i].l) {
          espVie-=1;
        }
      }
    }
  }

  public void decision() {
    tmpDecision--;
    if (tmpDecision<0) {//alors d\u00e9cide
      tmpDecision=100+(nbPics+nbQueues+nbAiles+nbYeuxC)*100;
      action++;
      if (action==3) {
        action=0;
      }
    }
    if (x>sceLX*0.95f) {
      action=2;
    }
    if (x<sceLX*0.05f) {
      action=1;
    }
    boolean tousFixes=true;
    for (int i=0;i<nbMonSS;i++) {
      if (monstre[mSSN[i]].action!=0) {
        tousFixes=false;
      }
    }
    if (tousFixes) {
      action=2;
    }    
  }

  public void deplace() {
    if (taille>=tOeuf) {
      if (action==0) {
        actEner=constrain(actEner-0.1f,0,1);
      }
      if (action==1 || action==2) {
        actEner=constrain(actEner+0.1f,0,1);
      }
      if (anime==true) {
        if (action==1) {
          x+=taille*actEner;
        }
        if (action==2) {
          x-=taille*actEner;
        }
      }
      prevtPosY=tPosY;
      tPosY=(tPosY+(tailleMax-taille)/(tailleMax*10))%TWO_PI;//d\u00e9place verticalement
      y=planSol[2]-sceLY/2+sin(tPosY)*(sceLY*min(taille,1)/16);
    }
  }

  public void pasRemue() {
    for (int i=0;i<nbVertebres;i++) {
      cVert[i]=0;     
      xVert[i]=0;
      yVert[i]=0;
      float recentre=sizModel/(nbVertebres*2);      
      float angle;      
      angle=atan2(yVert[i]-yVert[max(i-1,0)]+sizModel/nbVertebres,xVert[i]-xVert[max(i-1,0)])-HALF_PI;      
      xRVert[i]=xVert[i]+gVert[i]*cos(angle);
      yRVert[i]=yVert[i]+sizModel/nbVertebres*i+cVert[i]-mCY+gVert[i]*sin(angle)+recentre;
      angle=atan2(yVert[i]-yVert[max(i-1,0)]+sizModel/nbVertebres,xVert[i]-xVert[max(i-1,0)])+HALF_PI;      
      xRVert2[i]=xVert[i]+gVert[i]*cos(angle);
      yRVert2[i]=yVert[i]+sizModel/nbVertebres*i+cVert[i]-mCY+gVert[i]*sin(angle)+recentre;      
    }
    for (int i=0;i<nbQueues;i++) {
      queue[i].pasBouge();
    }
  }

  public void model() {// dessine le prototype en grand plan
    fill(0);
    if (plan==0 && phase==3) {
      fill(180);
    }
    float recentre=sizModel/(nbVertebres*2);
    beginShape();
    for (int i=0;i<nbVertebres;i++) {
      float angle=atan2(yVert[i]-yVert[max(i-1,0)]+sizModel/nbVertebres,xVert[i]-xVert[max(i-1,0)])-HALF_PI;
      xRVert[i]=xVert[i]+gVert[i]*cos(angle);
      yRVert[i]=yVert[i]+sizModel/nbVertebres*i+cVert[i]-mCY+gVert[i]*sin(angle)+recentre;
      vertex(xRVert[i],yRVert[i]);
    }
    for (int i=nbVertebres-1;i>=0;i--) {
      float angle=atan2(yVert[i]-yVert[max(i-1,0)]+sizModel/nbVertebres,xVert[i]-xVert[max(i-1,0)])+HALF_PI;
      xRVert2[i]=xVert[i]+gVert[i]*cos(angle);
      yRVert2[i]=yVert[i]+sizModel/nbVertebres*i+cVert[i]-mCY+gVert[i]*sin(angle)+recentre;
      vertex(xRVert2[i],yRVert2[i]);
    }
    endShape();
    for (int i=0;i<nbPics;i++) {
      pic[i].dessine();
    }
    for (int i=0;i<nbQueues;i++) {
      queue[i].agit();
      queue[i].dessine();
    }
    for (int i=0;i<nbAiles;i++) {
      aile[i].dessine();
    }
    for (int i=0;i<nbYeuxC;i++) {
      oeilC[i].dessine();
    }
    fill(255);
    for (int i=0;i<nbYeuxC;i++) {
      oeilC[i].dessinePupille();
    }
  }  

  public void modelFixe() {  
    fill(0);
    if (plan==0 && phase==3) {
      fill(180);
    }
    float recentre=sizModel/(nbVertebres*2);
    beginShape();
    for (int i=0;i<nbVertebres;i++) {
      float angle=atan2(sizModel/nbVertebres,0)-HALF_PI;
      xRVert[i]=gVert[i]*cos(angle);
      yRVert[i]=sizModel/nbVertebres*i-mCY+gVert[i]*sin(angle)+recentre;
      vertex(xRVert[i],yRVert[i]);
    }
    for (int i=nbVertebres-1;i>=0;i--) {
      float angle=atan2(sizModel/nbVertebres,0)+HALF_PI;
      xRVert2[i]=gVert[i]*cos(angle);
      yRVert2[i]=sizModel/nbVertebres*i-mCY+gVert[i]*sin(angle)+recentre;
      vertex(xRVert2[i],yRVert2[i]);
    }
    endShape();
    for (int i=0;i<nbPics;i++) {
      pic[i].dessine();
    }
    for (int i=0;i<nbQueues;i++) {
      queue[i].dessine();
    }
    for (int i=0;i<nbAiles;i++) {
      aile[i].dessine();
    }
    for (int i=0;i<nbYeuxC;i++) {
      oeilC[i].dessine();
    }
    fill(255);
    for (int i=0;i<nbYeuxC;i++) {
      oeilC[i].dessinePupille();
    }
  }  

  public void agitFaible() {// se fait aussi dans le bestiaire
    for (int i=0;i<nbYeuxC;i++) {
      oeilC[i].agit();
    }  
  }

  public void agit() {
    tC+=0.05f;
    tR-=0.09f;
    tC=tC%TWO_PI;
    tR=(tR+TWO_PI)%TWO_PI;    
    for (int i=0;i<nbVertebres;i++) {
      cVert[i]=sin(tC+i*TWO_PI/nbVertebres)*(sizModel/40);
      aVert[i]=tR+i*TWO_PI/nbVertebres;
      xVert[i]=cos(aVert[i])*(sizModel/40)*i/nbVertebres;
      yVert[i]=sin(aVert[i])*(sizModel/40)*i/nbVertebres;
    }
    if (anime==true) {
      for (int i=0;i<nbYeuxC;i++) {
        oeilC[i].agit();
      }
    }
  }       

}

int nbPays=5;
Pays[] pays=new Pays[nbPays];
int nbNotes=20;
int paysC=0;

public void chargePays() {
  float ecartY=height/nbPays;
  float ecartTY=ecartY*9/10;
  for (int i=0;i<nbPays;i++) {
    if (i==0) {
      int nbB=16;
      pays[i]=new Pays(nbB);
      pays[i].tempo=3;
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseV[i2]=(floor(random(5))+1)*10;
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseD[i2]=10+random(-5,5);
      }
      for (int i2=0;i2<nbB;i2++) {
        float ra=floor(random(5));
        if (ra==0) {
          pays[i].noiseF[i2]=21.83f;
        }
        if (ra==1) {
          pays[i].noiseF[i2]=32.7f;
        }        
        if (ra==2) {
          pays[i].noiseF[i2]=43.65f;
        }
        if (ra==3) {
          pays[i].noiseF[i2]=65.41f;
        }
        if (ra==4) {
          pays[i].noiseF[i2]=87.31f;
        }
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseA[i2]=5+random(-1,1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinV[i2]=(floor(random(5))+1)*10;
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinD[i2]=(floor(random(5))+1)*10;
      }
      for (int i2=0;i2<nbB;i2++) {
        float ra=floor(random(5));
        if (ra==0) {
          pays[i].sinF[i2]=21.83f;
        }
        if (ra==1) {
          pays[i].sinF[i2]=32.7f;
        }        
        if (ra==2) {
          pays[i].sinF[i2]=43.65f;
        }
        if (ra==3) {
          pays[i].sinF[i2]=65.41f;
        }
        if (ra==4) {
          pays[i].sinF[i2]=87.31f;
        }
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinA[i2]=5+random(-1,1);
      }  
      pays[i].freq=new float[]{
        10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200
      };
    }
    if (i==1) {
      int nbB=7;      
      pays[i]=new Pays(nbB);
      pays[i].tempo=6;
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseV[i2]=(floor(random(5))+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseD[i2]=pow(2,floor(random(3)))*500;  
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseF[i2]=pow(2,floor(random(3)))*20;  
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseA[i2]=1000*floor(random(3)+1);  
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinV[i2]=5*floor(random(1,4)+1);  
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinD[i2]=500*floor(random(3)+1);  
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinF[i2]=pow(2,floor(random(8)+1));
      }
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinA[i2]=1000*floor(random(3)+1);  
      }
      pays[i].freq=new float[]{
        1,1,2,2,4,4,8,8,16,16,32,32,64,64,128,128,256,256,512,1280
      };      
    }
    if (i==2) {
      int nbB=3;      
      pays[i]=new Pays(nbB);
      pays[i].tempo=20;
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseV[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseD[i2]=20+random(-10,10);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseF[i2]=10*floor(random(20)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseA[i2]=random(10);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinV[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinD[i2]=10*floor(random(50)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinF[i2]=10*floor(random(20)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinA[i2]=random(10);
      }      
      pays[i].freq=new float[]{
        1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
      };                     
    }    
    if (i==3) {
      int nbB=8;      
      pays[i]=new Pays(nbB);
      pays[i].tempo=4.5f;
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseV[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseD[i2]=10+random(-3,3);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseF[i2]=100*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseA[i2]=5+random(-3,3);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinV[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinD[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinF[i2]=100*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinA[i2]=random(4);
      }      
      pays[i].freq=new float[]{
        21.83f,32.70f,43.65f,55.00f,61.74f,65.41f,73.42f,77.78f,87.31f,98.00f,110.00f,123.47f,130.81f,146.83f,155.56f,174.61f,196.00f,220.00f,261.63f,349.23f
      };            
    }    
    if (i==4) {
      int nbB=10;
      pays[i]=new Pays(nbB);
      pays[i].tempo=4;
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseV[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseD[i2]=10+random(-3,3);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseF[i2]=5*floor(random(10)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].noiseA[i2]=5+random(-3,3);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinV[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinD[i2]=10*floor(random(5)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinF[i2]=5*floor(random(10)+1);
      }      
      for (int i2=0;i2<nbB;i2++) {
        pays[i].sinA[i2]=random(4);
      }
      float freqAMettre=5;
      for (int i2=0;i2<nbNotes;i2++) {
        freqAMettre=freqAMettre+random(20);
        pays[i].freq[i2]=freqAMettre;
      }
    }    
    pays[i].teinte=256*i/nbPays;
    pays[i].bouDX=50;
    pays[i].bouDY=ecartY*i+(ecartY-ecartTY)/2;
    pays[i].bouTX=width-100;
    pays[i].bouTY=ecartTY;
  }
}

class Pays {
  String nom;
  float teinte;
  float bouDX;
  float bouDY;
  float bouTX;
  float bouTY;
  int beats;
  float[] noiseV;
  float[] noiseD;
  float[] noiseF;
  float[] noiseA;  
  float[] sinV;
  float[] sinD;  
  float[] sinF;
  float[] sinA;  
  float tempo;
  float[] freq= new float[nbNotes];
  Pays(int beats) {
    this.beats=beats;
    noiseV=new float[beats];
    noiseD=new float[beats];
    noiseF=new float[beats];
    noiseA=new float[beats];
    sinV=new float[beats];
    sinD=new float[beats];
    sinF=new float[beats];
    sinA=new float[beats];
  }
}

public void phaseF() {// phase = 5
  recouvreF();
  affichePaysBoutons();
}

public void recouvreF() {
  image(fondPopUp,0,0);
}

int paysCprev;

public void affichePaysBoutons() {
  paysC=-1;
  for (int i=0;i<nbPays;i++) {
    noStroke();
    fill(0);
    rect(pays[i].bouDX,pays[i].bouDY,pays[i].bouTX,pays[i].bouTY);
    fill(pays[i].teinte,128,128);
    if (mouseX>pays[i].bouDX && mouseX<pays[i].bouDX+pays[i].bouTX && mouseY>pays[i].bouDY && mouseY<pays[i].bouDY+pays[i].bouTY) {
      fill(pays[i].teinte,192,192);
      paysC=i;
      tempo=pays[paysC].tempo;
      if (paysC!=paysCprev) {
        int montreTrois=3;
        for (int i2=0;i2<nbMonstres;i2++) {
          if (monstre[i2].type!=0) {
            montreTrois--;
            sendGeneral();
            envoieSon(i2);
            if (montreTrois==0) {
              break;
            }
          }
        }
      }
      paysCprev=paysC;    
    }
    rect(pays[i].bouDX+10,pays[i].bouDY+10,pays[i].bouTX-20,pays[i].bouTY-20);
  }
  if (paysC==-1) {
    paysC=0;
  }
}

float[] undo=new float[nbMembresMax*4];
int undoIndex;

boolean apercuvisible=false;

boolean interditOn=false;

String infoA="";
String infoB="";

float t1=0;
float xPrev=mCX/2;
float yPrev=mCY/2;
float cPresX=mCX;
float cPresY=mCY;
float controlAPrev=0.2f;
boolean anime=true;
int membreAAj;
boolean cmMenuOn=false;
int monsActTmp=0;
int moAE=0;//monstre \u00e0 \u00e9diter, pr\u00e9sentement

Boutons besRemonter =new Boutons("Observer",debModelx+sizModel/2+5,marBesGlo+marBes,sizModel/2-10,20,5,32, 192, 192, 200, 200, sizx/600*20);
Boutons besPaysoner =new Boutons("Climat",debModelx,marBesGlo+marBes,sizModel/2-10,20,5,50,100,150,100,150, sizx/600*20);

Boutons retourMenuOn = new Boutons("Nommer",debModelx, debModely+sizModel+10, sizModel/2-5, (sizy-40-debModely-sizModel)/2, 5, 200, 60, 60, 100, 150, sizx/600*17);
Boutons undoB = new Boutons("D\u00e9faire",debModelx+sizModel/2+5, debModely+sizModel+10, sizModel/2-5, (sizy-40-debModely-sizModel)/2, 5, 200, 60, 60, 100, 150, sizx/600*17);
Boutons besAurevoir =new Boutons("Supprimer",debModelx, debModely+sizModel+(sizy+10-debModely-sizModel)/2, sizModel/2-5, (sizy-40-debModely-sizModel)/2, 5, 200, 60, 60, 100, 150, sizx/600*17);
Boutons besUtiliser =new Boutons("Inclure",debModelx+sizModel/2+5, debModely+sizModel+(sizy+10-debModely-sizModel)/2, sizModel/2-5, (sizy-40-debModely-sizModel)/2, 5, 200, 60, 60, 100, 150, sizx/600*17);

Boutons newC =new Boutons("ciel",debModelx+5, debModely+ (sizy-debModely-15)/8*1, sizModel-10, (sizy-debModely-15)/8, 5, 200, 60, 60, 100, 150, sizx/600*30);
Boutons newB =new Boutons("terre",debModelx+5, debModely+ (sizy-debModely-15)/8*3, sizModel-10, (sizy-debModely-15)/8, 5, 200, 60, 60, 100, 150, sizx/600*30);
Boutons newA =new Boutons("eau",debModelx+5, debModely+ (sizy-debModely-15)/8*5, sizModel-10, (sizy-debModely-15)/8, 5, 200, 60, 60, 100, 150, sizx/600*30);
Boutons newR =new Boutons("g\u00e9n\u00e9rer",debModelx+5, debModely+ (sizy-debModely-15)/8*7, sizModel-10, (sizy-debModely-15)/8, 5, 200, 60, 60, 100, 150, sizx/600*30);

float mvtMouse;
float prevMouseX;
float prevMouseY;

public void phaseC() {
  if (moAE!=prevmoAE){//si le joueur change de monstre
    cmMenuOn=false;
    prevmoAE=moAE;
    undoIndex=0;
  }  
  if (moAE!=-1) {
    if (monstre[moAE].type==1) {
      lignePrevs();    
      recouvreC();
      soussolEditShape();
      afficheLeGrosMonstre();
      autresBoutonsEdit();
      elementsPreview();
      cmMenu();
      afficheNom();   
    }
    if (monstre[moAE].type==2) {
      teShapeOn=false;
      lignePrevs();    
      recouvreC();
      monstresAgissent();
      terreEditShape();
      afficheLeGrosMonstre();
      autresBoutonsEdit();
      elementsPreview();
      cmMenu();
      afficheNom();
    }
    if (monstre[moAE].type==3) {
      lignePrevs();    
      recouvreC();
      cielEditShape();    
      afficheLeGrosMonstre();
      autresBoutonsEdit();
      elementsPreview();
      cmMenu();
      afficheNom(); 
    }
    if (mousePressed && mouseButton==RIGHT) {
      mvtMouse+=longueur(mouseX,mouseY,prevMouseX,prevMouseY);
      if (mvtMouse>(width+height)/10) {
        mvtMouse=0;
        envoieSon(moAE);
      }
    }
    else{
      mvtMouse=(width+height)/10;
    }
    prevMouseX=mouseX;
    prevMouseY=mouseY;    
  }
  afficheInfoA();   
}

public void afficheInfoA() {
  if (langue==0) {
    infoA="cliquer sur 'observer' pour";
    infoB="voir la sc\u00e8ne";
  }
  if (langue==1) {
    infoA="click on 'watch' to";
    infoB="see the scene";
  }
  if (besRemonter.actif()) {
    if (langue==0) {    
      infoA="clic droit = revenir ici";
      infoB="clic gauche = changer le climat";
    }
    if (langue==1) {
      infoA="right click = return";
      infoB="left click = change mood";
    }
  }
  if (moAE!=-1) {  
    if (monstre[moAE].type!=0) {
      if (mouseX>debModelx&&mouseY>debModely&&mouseX<sizModel+debModelx&&mouseY<sizModel+debModely) {
        if (langue==0) {            
          infoA="clic droit = ajouter un membre";
          infoB="clic gauche = modeler le monstre";
        }
        if (langue==1) {    
          infoA="right click = add limb";
          infoB="left click = shape the monster";
        }    
      }    
      boolean essaieTropM=false;
      if (cmMenuOn) {
        if(mouseX<xPrev2+20 && mouseX>xPrev2-20 && mouseY<yPrev+20 && mouseY>yPrev-20){
          if (mouseX<xPrev2) {
            if (mouseY<yPrev) {
              if (langue==0) {                          
                infoA="ajoute ce membre";
              }
              if (langue==1) {            
                infoA="add this limb";
              }                  
              infoB="";
              if (fullMembred[0]) essaieTropM=true;
            }
            else {
              if (langue==0) {                          
                infoA="ajoute ce membre";
              }
              if (langue==1) {            
                infoA="add this limb";
              }           
              infoB="";            
              if (fullMembred[2]) essaieTropM=true;          
            }
          }
          else {
            if (mouseY<yPrev) {
              if (langue==0) {                          
                infoA="ajoute ce membre";
              }
              if (langue==1) {            
                infoA="add this limb";
              }
              infoB="";            
              if (fullMembred[1]) essaieTropM=true;
            }
            else {
              if (langue==0) {                          
                infoA="ajoute un oeil";
              }
              if (langue==1) {            
                infoA="add an eye";
              }
              infoB="";            
              if (fullMembred[3]) essaieTropM=true;
            }
          }
        }
      }
      if (tryADeprecat) {
        if (langue==0) {
          infoA="membre trop proche du corps";
          infoB="seul un oeil peut \u00eatre pos\u00e9 ici";
        }
        if (langue==1) {
          infoA="limb too close to the body";
          infoB="only eyes can be added here";
        }        
      }      
      if (essaieTropM) {
        if (langue==0) {        
          infoA="le monstre contient d\u00e9j\u00e0";
          infoB="suffisemment de membres de ce type";
        }
        if (langue==1) {        
          infoA="maximum limb type number reached";
          infoB="";
        }
      }     
      if (undoB.actif()) {
        if (langue==0) {                
          infoA="retire le dernier membre pos\u00e9";
        }
        if (langue==1) {        
          infoA="remove last added limb";
        }        
        infoB="";
      }
      if (besUtiliser.actif()) {
        if (besUtiliser.label=="Inclure") {
          if (langue==0) {
            infoA="d\u00e9pose le monstre dans la sc\u00e8ne";
          }
          if (langue==1) {             
            infoA="add the monster to the scene";
          }                
          infoB="";
        }
        else {
          if (langue==0) {          
            infoA="retire le monstre de la sc\u00e8ne";
          }
          if (langue==1) {          
            infoA="remove the monster from the scene";
          }                
          infoB="";          
        }
      }      
    }
    if (monstre[moAE].type==0) {
      if (newR.actif()) {
        if (langue==0) {
          infoA="g\u00e9n\u00e8re un monstre al\u00e9atoirement";
        }
        if (langue==1) {            
          infoA="random monster generation";
        }                
        infoB="";
      }
      if (newA.actif()) {
        if (langue==0) {  
          infoA="cr\u00e9e un monstre sous-terrain";
        }
        if (langue==1) {        
          infoA="create a deep monster";                
        }
        infoB="";
      }    
      if (newB.actif()) {
        if (langue==0) {
          infoA="cr\u00e9e un monstre terrien";
        }
        if (langue==1) {
          infoA="create an earthly monster";
        }        
        infoB="";
      }    
      if (newC.actif()) {
        if (langue==0) {        
          infoA="cr\u00e9e un monstre a\u00e9rien";
        }
        if (langue==1) {
          infoA="create a flying monster";                
        }
        infoB="";
      }
    }
  }
  fill(255);
  textFont(font[0], sizModel/20);
  textAlign(CENTER,CENTER);
  text(infoA, debModelx+sizModel/2, debModely-(sizModel/14)*4);
  text(infoB, debModelx+sizModel/2, debModely-(sizModel/14)*3);
}

public void afficheNom() {
  fill(255);
  textFont(font[0], sizModel/16);
  textAlign(CENTER,CENTER);
  text(monstre[moAE].nom, debModelx, debModely-sizModel/7,sizModel,sizModel/10);
}

public float symX(float n) {//calcule les sym\u00e9triques pour le monstre C
  return ((debModelx+mCX)-(n-(debModelx+mCX)));
}

float correctionAngle;
float lonT;//longueur corps/nouveau membre
public float mouseX2() {//souris symm\u00e9trique pour les monstres du ciel
  float value=mouseX;
  if (mouseX<(debModelx+mCX)) {
    value=symX(mouseX);
  }
  return value;
}

float mouseXF;
float mouseYF;  

public void lignePrevs() {
  if (!cmMenuOn) {//si le menu de choix des membres n'est pas activ\u00e9
    mouseXF=mouseX;
    mouseYF=mouseY;
    if (mouseX>debModelx && mouseY>debModely && mouseX<sizModel+debModelx && mouseY<sizModel+debModely) {
      if (monstre[moAE].type==1) {
        mAJLignePrev();
        float vraiX1=monstre[moAE].bourseL[(att-1+nbBourses)%nbBourses]*cos(monstre[moAE].bourseR[(att-1+nbBourses)%nbBourses]);
        float vraiY1=monstre[moAE].bourseL[(att-1+nbBourses)%nbBourses]*sin(monstre[moAE].bourseR[(att-1+nbBourses)%nbBourses]);
        float vraiX2=monstre[moAE].bourseL[(att+1)%nbBourses]*cos(monstre[moAE].bourseR[(att+1)%nbBourses]);
        float vraiY2=monstre[moAE].bourseL[(att+1)%nbBourses]*sin(monstre[moAE].bourseR[(att+1)%nbBourses]);
        lonT=longueur(mouseX,mouseY,cPresX,cPresY);
        float angleV=atan2(vraiY2-vraiY1,vraiX2-vraiX1)-HALF_PI;
        correctionAngle=atan2(mouseY-cPresY,mouseX-cPresX)-angleV;
        xPrev=lonT*cos(angleV+correctionAngle)+cPresX;
        yPrev=lonT*sin(angleV+correctionAngle)+cPresY;
      }
      if (monstre[moAE].type==2) {
        mAJLignePrev();        
        xPrev=mouseX;
        yPrev=mouseY;
      }
      if (monstre[moAE].type==3) {
        mAJLignePrev();
        lonT=longueur(mouseX2(),mouseY,cPresX,cPresY);
        int rang=constrain(floor((mouseY-debModely)*nbVertebres/sizModel),0,nbVertebres-2);
        boolean interi=(mouseX2()<monstre[moAE].xRVert[rang]+mCX+debModelx);
        float vraiX1=monstre[moAE].xRVert[max(att-1,0)];
        float vraiX2=monstre[moAE].xRVert[min(att+1,nbVertebres-1)];
        float angleV=atan2(sizModel/nbVertebres*2,vraiX2-vraiX1)-HALF_PI;
        correctionAngle=atan2(mouseY-cPresY,mouseX2()-cPresX)-angleV;
        xPrev=lonT*cos(angleV+correctionAngle)+cPresX;
        yPrev=lonT*sin(angleV+correctionAngle)+cPresY;
      }
    }
  }
}

public boolean deprecated() {
  boolean blop=true;
  float seuil=sizModel/30;
  if (moAE!=-1) {
    if (monstre[moAE].type==1) {
      if (!cmMenuOn) {
        att=rechercheCorpsPres();
      }
      if (longueur(mouseXF,mouseYF,debModelx+mCX,debModely+mCY)>seuil+monstre[moAE].bourseL[att]) {
        blop=false;        
      }
      else{
        blop=true;        
      }
    }    
    if (monstre[moAE].type==2) {
      if (!cmMenuOn) {
        att=rechercheCorpsPres();
      }
      if (longueur(mouseXF,mouseYF,monstre[moAE].corps[att].xR+debModelx+mCX,monstre[moAE].corps[att].yR+debModely+mCY)>seuil+monstre[moAE].corps[att].r) {
        blop=false;
      }
      else{
        blop=true;
      }    
    }
    if (monstre[moAE].type==3) {
      int rang=constrain(floor((mouseYF-debModely)*nbVertebres/sizModel),0,nbVertebres-2);    
      if (longueur(mouseX2(),mouseYF,cPresX,cPresY)>seuil && (mouseX2()>=(monstre[moAE].xRVert[rang]+monstre[moAE].xRVert[(rang+1)%nbVertebres])/2+mCX+debModelx)) {
        blop=false;
      }
      else{
        blop=true;
      }
    }
  }
  return blop;
}

float marSMembres=sizx/10;

public void recouvreC() {
  noStroke();
  fill(pays[paysC].teinte,60,120);
  if (monstre[moAE].taille>=tOeuf) {
    rect(debModelx,debModely,sizModel,sizModel);
  }
  else {
    ellipse(debModelx+mCX,debModely+mCY,sizModel*0.75f,sizModel);
  }
  if (monstre[moAE].type==2 && monstre[moAE].taille>=tOeuf) {
    fill(pays[paysC].teinte,60,60);
    rect(debModelx,debModely+sizModel-marSMembres,sizModel,marSMembres);
  }
  fill(0);
}

public void pasRemue() {
  monstre[moAE].pasRemue();
}

public void afficheLeGrosMonstre() {
  pushMatrix();
  translate(mCX+debModelx, mCY+debModely);
  monstre[moAE].regarde(mouseX-debModelx-mCX,mouseY-debModely-mCY);
  monstre[moAE].agitFaible();  
  monstre[moAE].modelFixe();
  popMatrix();
}

public void monstresAgissent() {
  for (int i=0;i<nbMonstres;i++) {
    monstre[i].agit();
  }
}

public void changeLangue() {
  if (langue==0) {
    besRemonter.label="Observer";
    besPaysoner.label="Climat";
    retourMenuOn.label="Nommer";    
    undoB.label="D\u00e9faire";    
    besAurevoir.label="Supprimer";    
    newC.label="ciel";    
    newB.label="terre"; 
    newA.label="eau";    
    newR.label="g\u00e9n\u00e9rer";    
    exImporter.label="Importer"; 
    exExporter.label="Exporter";
  }  
  if (langue==1) {
    besRemonter.label="Watch";
    besPaysoner.label="Mood";
    retourMenuOn.label="Name";
    undoB.label="Undo";
    besAurevoir.label="Delete";
    newC.label="sky";
    newB.label="earth";
    newA.label="deep";
    newR.label="random";
    exImporter.label="Import";
    exExporter.label="Export";
  }   
}

public void autresBoutonsEdit() {
  retourMenuOn.teinte=(pays[paysC].teinte+32)%256;
  retourMenuOn.dessine();
  if (undoIndex>0) {
    undoB.teinte=(pays[paysC].teinte+32)%256;
    undoB.dessine();  
  }
}

boolean entreIci;
boolean eShape;

int prevmoAE;

public void sourisPhaseC() {
  eShape=cmMenuOn;
  if (undoB.actif()) {
    undo();
  }
  if (mouseButton==RIGHT && cmMenuOn==false) {
    if (moAE!=-1) {
      if (monstre[moAE].type==1) {
        soussolEditShape();
      }
      if (monstre[moAE].type==2) {
        terreEditShape();
      }
      if (monstre[moAE].type==3) {
        cielEditShape();
      }
    }
  }
  rajoute();
  if (moAE!=-1) {
    if (monstre[moAE].type==0) {
      if (newA.actif()) {
        monstre[moAE]=new MonstresA(moAE);
        monstre[moAE].sS=true;
      }
      else if (newB.actif()) {
        monstre[moAE]=new MonstresB(moAE);
        monstre[moAE].sS=true;    
      }
      else if (newC.actif()) {
        monstre[moAE]=new MonstresC(moAE);
        monstre[moAE].sS=true;    
      }    
      else if (newR.actif()) { 
        EditR();
      }
      entreIci=true;
      cmMenuOn=false;      
    }
    else if (retourMenuOn.actif()==true) {
      undoIndex=0;
      monstre[moAE].sS=true;
      mAJmSSN();
      loadPopup();
      placeAuto();
      phase=4;
    }
    else if (besUtiliser.actif()==true) {
      if (moAE!=-1) {
        if (monstre[moAE].type!=0) {
          if (monstre[moAE].sS==true) {
            monstre[moAE].sS=false;
          }
          else{    
            monstre[moAE].sS=true;
          }
        }
        mAJmSSN();
        placeAuto();
      }
    }    
    else if (besAurevoir.actif()==true) {
      if (moAE!=-1) {
        if (monstre[moAE].type==0) {
          loadPopup();
          phase=6;
          entreIci=true;
        }
        else{
          monstre[moAE]=new MonstresMorts(moAE);
        }
      }
    }
  }
  if (besRemonter.actif()==true) {
    noCursor();
    phase=3;
    mAJmSSN();
    placeAuto();
    besDescendre.teinte=pays[paysC].teinte;
    setDecors();
  }  
  else if (besPaysoner.actif()==true) {
    chargePays();
    loadPopup();
    phase=5;
  }  
}

public void rajoute() {
  if (mouseButton==LEFT && cmMenuOn==false && hgDessus() && !entreIci) {
    if (mouseX>debModelx && mouseY>debModely && mouseX<sizModel+debModelx && mouseY<sizModel+debModely) {
      cmMenuOn=true;
      if (deprecated()) {
        tryADeprecat=true;
      }
    }
  } 
  else if (cmMenuOn==true) {
    if(mouseX<xPrev2+20 && mouseX>xPrev2-20 && mouseY<yPrev+20 && mouseY>yPrev-20){
      if (mouseX<xPrev2) {
        if (mouseY<yPrev) {
          membreAAj=0;
        }
        else {
          membreAAj=1;        
        }
      }
      else {
        if (mouseY<yPrev) {
          membreAAj=2;
        }
        else {
          membreAAj=3;        
        }
      }
      if (membreAAj==0) {
        if (!tryADeprecat) {
          if (monstre[moAE].type==1) {
            nbCilsP();
          }
          if (monstre[moAE].type==2) {
            nbCorpsP();
          }
          if (monstre[moAE].type==3) {
            nbPicsP();
          }
        }
        else{
          interditOn=true;
          sonDeprec(1);
        }
      }
      if (membreAAj==1) {
        if (!tryADeprecat) {        
          if (monstre[moAE].type==1) {
            nbBrasP();
          }      
          if (monstre[moAE].type==2) {
            nbBecsP();
          }
          if (monstre[moAE].type==3) {
            nbAilesP();
          }
        }        
        else{
          interditOn=true;
          sonDeprec(1);
        }
      }
      if (membreAAj==2) {
        if (!tryADeprecat) {        
          if (monstre[moAE].type==1) {
            nbTentaculesP();
          }
          if (monstre[moAE].type==2) {
            nbJambesP();
          }
          if (monstre[moAE].type==3) {
            nbQueuesP();
          }        
        }        
        else{
          interditOn=true;
          sonDeprec(1);
        }
      }
      if (membreAAj==3) {
        if (monstre[moAE].type==1) {
          nbYeuxAP();
        }
        if (monstre[moAE].type==2) {
          nbYeuxP();
        }
        if (monstre[moAE].type==3) {
          nbYeuxCP();
        }
      }
    }
    else {
      cmMenuOn=false;
    }
  }
}

public void cielEditShape() {
  if (mousePressed && mouseButton==RIGHT) {
    if (mouseX>debModelx && mouseY>debModely && mouseX<debModelx+sizModel && mouseY<debModely+sizModel) {
      if (!eShape && !entreIci) {
        int vAE=floor((mouseY-debModely)*nbVertebres/sizModel);//vertebre a editer
        int dista=max(floor(10-(abs(mouseX-(debModelx+mCX))/mCX*10)),1);
        int dep=floor(constrain(vAE-dista,0,nbVertebres-1));
        int arr=floor(constrain(vAE+dista,0,nbVertebres-1));
        int eca=arr-dep;
        for (int i=dep;i<arr;i++) {
          float valeur=0;
          float fade1=constrain((((float)eca/2)-(i-(float)dep))/((float)eca/2),0,1);
          float fade2=constrain(((i-(float)dep)-((float)eca/2))/((float)eca/2),0,1);
          float reste=1-fade1-fade2;
          valeur+=monstre[moAE].gVert[i]+abs((mouseX-debModelx)-mCX)*reste;
          valeur+=monstre[moAE].gVert[i]*(fade1+fade2);
          monstre[moAE].gVert[i]=valeur/2;
        }
        for (int i=0;i<monstre[moAE].nbQueues;i++) {
          monstre[moAE].queue[i].pasBouge();
        }        
      }
    }
  }
}

boolean teShapeOn;
float teShapeX;
float teShapeY;
float teShapeS;

public void terreEditShape() {
  if (mousePressed && mouseButton==RIGHT) {
    if (mouseX>debModelx && mouseY>debModely && mouseX<debModelx+sizModel && mouseY<debModely+sizModel) {
      if (!eShape && !entreIci) {
        teShapeX=debModelx+mCX+monstre[moAE].corps[rechercheCorpsPres()].xR;
        teShapeY=debModely+mCY+monstre[moAE].corps[rechercheCorpsPres()].yR;
        teShapeS=longueur(teShapeX,teShapeY,mouseX,mouseY);
        monstre[moAE].corps[rechercheCorpsPres()].r=teShapeS;
        teShapeOn=true;        
      }
    }
  }
}

public void soussolEditShape() {
  if (mousePressed && mouseButton==RIGHT) {
    if (mouseX>debModelx && mouseY>debModely && mouseX<debModelx+sizModel && mouseY<debModely+sizModel) {
      if (!eShape && !entreIci) {      
        int bonneBourse=0;
        float raySour=(atan2(mouseY-debModely-mCY,mouseX-debModelx-mCX)+TWO_PI)%TWO_PI;
        for (int i=0;i<nbBourses;i++) {
          if (abs(vrMax(raySour,monstre[moAE].bourseR[i],TWO_PI))<abs(vrMax(raySour,monstre[moAE].bourseR[bonneBourse],TWO_PI))) {
            bonneBourse=i;
          }
        }
        monstre[moAE].bourseR[bonneBourse]=raySour;
        int lenteur=constrain(floor((nbBourses-longueur(mouseX,mouseY,debModelx+mCX,debModely+mCY)*nbBourses/sizModel)/5),0,nbBourses);
        for (int i=-lenteur;i<lenteur;i++) {//raccorde \u00e0 la souris
          int i2=(bonneBourse+i+nbBourses)%nbBourses;
          monstre[moAE].bourseL[i2]=monstre[moAE].bourseL[i2]/lenteur*abs(i);
          monstre[moAE].bourseL[i2]+=longueur(mouseX,mouseY,debModelx+mCX,debModely+mCY)/lenteur*(lenteur-abs(i));
        }
        for (int i=0;i<nbBourses;i++) {//\u00e9loigne les points de la souris
          float distan=vrMax(monstre[moAE].bourseR[bonneBourse],monstre[moAE].bourseR[i],TWO_PI);
          monstre[moAE].bourseR[i]=(monstre[moAE].bourseR[i]+distan*(TWO_PI-abs(distan))/1000+TWO_PI)%TWO_PI;
        }
        for (int i=0;i<nbBourses;i++) {//emp\u00eache les croisements
          monstre[moAE].bourseR[i]+=max(vrMax(monstre[moAE].bourseR[i],monstre[moAE].bourseR[(i-1+nbBourses)%nbBourses],TWO_PI),-0.01f);    
          monstre[moAE].bourseR[i]+=min(vrMax(monstre[moAE].bourseR[i],monstre[moAE].bourseR[(i+1)%nbBourses],TWO_PI),0.01f);
        }
        for (int i=0;i<nbBourses;i++) {//replace un peu les points comme au d\u00e9but
          monstre[moAE].bourseR[i]+=vrMax(monstre[moAE].bourseR[i],(TWO_PI*i/nbBourses),TWO_PI)/50;
        }
        for (int i=0;i<nbBourses;i++) {//smooth le tout
          int in=(i+1)%nbBourses;
          int in2=(i-1+nbBourses)%nbBourses;
          monstre[moAE].bourseL[i]=monstre[moAE].bourseL[i]*48/50;
          monstre[moAE].bourseL[i]+=monstre[moAE].bourseL[in]*1/50;
          monstre[moAE].bourseL[i]+=monstre[moAE].bourseL[in2]*1/50;
        }
        for (int i=0;i<monstre[moAE].nbTentacules;i++) {
          monstre[moAE].tentacule[i].pasBouge();
        }
      }
    }
  }
}

public float vrMax(float a, float b, float m) {
  float d1=b-a;
  if (d1>m/2) {
    d1=d1-m;
  }
  if (d1<-m/2) {
    d1=d1+m;
  }
  return d1;
}

int typeCurseur=0;
float margeCur=sizy/15;

//place de la sc\u00e8ne :
float sceLX;//longueur des sc\u00e8nes en x
float sceDY=margeCur;//debut da la premi\u00e8re sc\u00e8ne en y
float sceEY=sizy/15;//separation des sc\u00e8nes en y
float sceLY=((sizy-(2*margeCur)-(sceEY*2))/3);//longueur des sc\u00e8nes en y
float sceLTY=sceLY*3+sceEY*2;//longueur totale en Y;

float[] planSol=new float[3];
float reducScene;

float camPos;//position de la "cam\u00e9ra"

Boutons besDescendre =new Boutons("Descendre",sizx/5*2,sizy-50,sizx/5,30,5,200,40,70,140,170);

int beat=0;//beat actuel
int beatDiv=16;//division de la mesure

int teinteEau;

public void phaseD() {
  bougeCamera();
  recouvreD();
  afficheMonstresScene();
  if (recordOn==true) {
    mm.addFrame();
  }
  afficheLedsSon();
  //  menuScene();
}

public void chargeScene() {
  reducScene=sceLY/(sizModel*4);
  planSol[0]=sceDY+sceLY*3+sceEY*2;
  planSol[1]=sceDY+sceLY*2+sceEY;
  planSol[2]=sceDY+sceLY;
}

int nbPtEau=15;//nombre de vertex pour la surface de l'eau
float[] eauY=new float[nbPtEau];
float tEau=0;
float tEau2=0;

public void eauBouge() {
  tEau+=0.25f;
  tEau=tEau%TWO_PI;
  tEau2+=0.05f;
  tEau2=tEau2%TWO_PI; 
  for (int i=0;i<nbPtEau;i++) {
    eauY[i]=sin(tEau+(TWO_PI*4/nbPtEau*i))*(sceEY*3/5);
    eauY[i]+=sin(tEau2+(TWO_PI*5/nbPtEau*(nbPtEau-i)))*(sceEY*1/5);
  }
}

int nbPtHor=100;//nombre de vertex pour l'horizon
int scorchHor=6;//relief de l'horizon
float[] horY=new float[nbPtHor];
float disHor=2;//distance de l'horizon

int nbPtHorDer=100;//nombre de vertex pour l'horizon
int scorchHorDer=4;//relief de l'horizon
float[] horYDer=new float[nbPtHorDer];
float disHorDer=5;//distance de l'horizon

public void setDecors() {
  horY[0]=0;
  for (int i=1;i<nbPtHor;i++) {
    horY[i]=constrain(horY[i-1]+random(-scorchHor, scorchHor),-sceEY/2,sceEY/2);
  }
  horYDer[0]=0;
  for (int i=1;i<nbPtHorDer;i++) {
    horYDer[i]=constrain(horYDer[i-1]+random(-scorchHorDer, scorchHorDer),-sceEY/2,sceEY/2);
  }  
}

float teinteAct=0;

public void recouvreD() {
  teinteAct=(teinteAct+vrMax(teinteAct,pays[paysC].teinte,256)/20+256)%256;

  background(0);
  noStroke();
  pushMatrix();
  scale(1.0f/disHorDer,1);  
  translate(-camPos,0);
  fill(teinteAct,40,180);
  beginShape();
  vertex(0,sceDY);
  vertex(sceLX*disHorDer,sceDY);
  vertex(sceLX*disHorDer,sceDY+sceLY-sceEY*1.5f);  
  for (int i=nbPtHorDer-1;i>=0;i--) {
    vertex((sceLX/nbPtHorDer*i+(sceLX/(nbPtHorDer*2)))*disHorDer,sceDY+sceLY+horYDer[i]-sceEY);
  }  
  vertex(0,sceDY+sceLY-sceEY*1.5f);  
  vertex(0,sceDY);  
  endShape();
  fill(teinteAct,60,160);
  popMatrix();
  pushMatrix();
  scale(1.0f/disHor,1);
  translate(-camPos,0);
  beginShape();
  vertex(0,sceDY+sceLY*2+sceEY);
  vertex(0,sceDY+sceLY+sceEY*1.5f);
  for (int i=0;i<nbPtHor;i++) {
    vertex((sceLX/nbPtHor*i+(sceLX/(nbPtHor*2)))*disHor,sceDY+sceLY+horY[i]+sceEY);
  }
  vertex(sceLX*disHor,sceDY+sceLY+sceEY*1.5f);
  vertex(sceLX*disHor,sceDY+sceLY*2+sceEY);
  vertex(0,sceDY+sceLY*2+sceEY);
  endShape();
  popMatrix();
  pushMatrix();
  translate(-camPos,0);
  //  teinteEau=lerpColor(color(pays[paysC].teinte,80,50), color(200,64,128), abs(tEau2-PI)/15);
  teinteEau=color(teinteAct,40,64);
  fill(teinteEau);
  eauBouge();
  beginShape();
  vertex(0,sceDY+(sceLY+sceEY)*2+sceLY);
  vertex(0,sceDY+(sceLY+sceEY)*2);
  for (int i=0;i<nbPtEau;i++) {
    curveVertex(sceLX/nbPtEau*i+(sceLX/(nbPtEau*2)),sceDY+(sceLY+sceEY)*2+eauY[i]);
  }
  vertex(sceLX,sceDY+(sceLY+sceEY)*2);  
  vertex(sceLX,sceDY+(sceLY+sceEY)*2+sceLY);
  vertex(0,sceDY+(sceLY+sceEY)*2+sceLY);
  endShape();
  popMatrix();
  if (anime==true) {
    t1+=0.05f;
    t1=t1%TWO_PI;
  }
  pasOn=false;
}

boolean auClavier=false;

public void bougeCamera() {
  if (!auClavier) {
    float camBou=map(mouseX,0,width,0,sceLX-width);
    camPos=(camBou+camPos)/2;
  }
}

public void afficheMonstresScene() {
  for (int i=0;i<nbMonSS;i++) {
    if (monstre[mSSN[i]].type!=0) {
      monstre[mSSN[i]].decision();
      monstre[mSSN[i]].deplace();
      monstre[mSSN[i]].agit();
      monstre[mSSN[i]].vit();//risque de mort
    }
  }
  mAJmSSN();//MAJ en cas de mort
  for (int i=0;i<nbMonSS;i++) {
    if (monstre[mSSN[i]].type!=0) {
      monstre[mSSN[i]].rencontre();//risque de mort
    }
  }
  mAJmSSN();//MAJ en cas de mort
  for (int i=0;i<nbMonSS;i++) {
    if (monstre[mSSN[i]].type!=0) {
      if (monstre[mSSN[i]].taille>=tOeuf) {
        pushMatrix();
        translate(monstre[mSSN[i]].x-camPos,monstre[mSSN[i]].y);
        scale(reducScene*monstre[mSSN[i]].taille);
        monstre[mSSN[i]].regardMProche();        
        monstre[mSSN[i]].model();
        popMatrix();
        if (monstre[mSSN[i]].dansLoeuf) {
          monstre[mSSN[i]].dansLoeuf=false;
          if (monstre[mSSN[i]].x>camPos && monstre[mSSN[i]].x<camPos+width) {
            if (pasAct) {
              eclosSon((monstre[mSSN[i]].x-camPos)/width);
            }
          }
        }
      }
      else {//oeuf
        monstre[mSSN[i]].dansLoeuf=true;
        pushMatrix();
        translate(monstre[mSSN[i]].x-camPos,monstre[mSSN[i]].y);
        scale(reducScene);
        fill(0);
        ellipse(0,0,sizModel/2,sizModel*2/3);
        popMatrix();
      }
    }
  }
  curseur();
  if (pasOn==true) {//bruit de pas
    ledPas=true;
  }
  else{  
    ledPas=false;
  }
}

float tempo=3;
float tempoWaiter=tempo;
int ledPays;

boolean tempoDefile=true;

public void curseur() {
  beatDiv=pays[paysC].beats;
  if (tempoDefile) {
    tempoWaiter--;
  }
  if (tempoWaiter<=0) {
    tempoWaiter=tempo;    
    beat=(beat+1)%beatDiv;
    curPos=(float)width/beatDiv*beat+(width/(beatDiv*2));
    ledPays=floor(curPos/width*beatDiv);
    for (int i=0;i<nbMonSS;i++) {
      if ((float)abs(curPos+camPos-monstre[mSSN[i]].x)<=(float)(width/(beatDiv*2))) {
        //cri du monstre i
        monstre[mSSN[i]].chante=1;
        ledCri[i]=true;
      }
      else {
        //pas de cri du monstre i
        ledCri[i]=false;
      }
    }
  }
  else{
    ledPays=-1;
    for (int i=0;i<nbMonSS;i++) {
      ledCri[i]=false;
    }
  }
  if (typeCurseur==0) {
    noStroke();
    fill(pays[paysC].teinte,100,100);
    triangle(curPos-(width/(beatDiv*2)),0,curPos-(width/(beatDiv*2))+width/beatDiv,0,curPos-(width/(beatDiv*2))+width/(beatDiv*2),margeCur);
    triangle(curPos-(width/(beatDiv*2)),height,curPos-(width/(beatDiv*2))+width/beatDiv,height,curPos-(width/(beatDiv*2))+width/(beatDiv*2),height-margeCur);    
  }
  if (typeCurseur==1) {
  }
  if (typeCurseur==2) {
    noStroke();
    fill(pays[paysC].teinte,100,100,100);
    rect(curPos-(width/(beatDiv*2)),0,width/beatDiv,height);    
  }  
}

public void menuScene() {
  besDescendre.dessine();
}

public void MAJSceneTaille() {
  mAJmSSN();
  sceLX=max(nbMonSS/5*width,sizx*1.5f);//d\u00e9finit la taille en x en fonction du nombre de monstres
}

public void sourisPhaseD() {
  //  if(besDescendre.actif()==true) {
  if (mouseButton==LEFT) {
    entreIci=true;
    allerAuBestiaire();
  }
  //  }
  if (mouseButton==RIGHT) {
    chargePays();
    paysC=(paysC+1)%nbPays;
    tempo=pays[paysC].tempo;      
    sendGeneral();    
  }  
}

public void undo() {
  if (undoIndex>0) {
    if (undo[undoIndex-1]==0) {
      if (monstre[moAE].type==1) {
        nbCilsM();
      }
      if (monstre[moAE].type==2) {
        nbCorpsM();
      }
      if (monstre[moAE].type==3) {
        nbPicsM();
      }
    }
    else if (undo[undoIndex-1]==1) {
      if (monstre[moAE].type==1) {
        nbBrasM();
      }
      if (monstre[moAE].type==2) {
        nbBecsM();
      }
      if (monstre[moAE].type==3) {
        nbAilesM();
      }
    }
    else if (undo[undoIndex-1]==2) {
      if (monstre[moAE].type==1) {
        nbTentaculesM();
      }
      if (monstre[moAE].type==2) {
        nbJambesM();
      }
      if (monstre[moAE].type==3) {
        nbQueuesM();
      }
    }
    else if (undo[undoIndex-1]==3) {
      if (monstre[moAE].type==1) {
        nbYeuxAM();
      }
      if (monstre[moAE].type==2) {
        nbYeuxM();
      }
      if (monstre[moAE].type==3) {
        nbYeuxCM();
      }
    }
  }
}

public void nbCilsP() {
  if (monstre[moAE].nbCils<10) {
    monstre[moAE].nbCils++;
    Cils tmpCils=new Cils(moAE,att,lonT,correctionAngle);
    monstre[moAE].cil[monstre[moAE].nbCils-1]=tmpCils;
    undo[undoIndex]=0;
    undoIndex++;
    monstre[moAE].espVie+=300;
    envoieSon(moAE);    
    cmMenuOn=false;
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }
}
public void nbTentaculesP() {
  if (monstre[moAE].nbTentacules<10) {
    monstre[moAE].nbTentacules++;
    Tentacules tmpTentacules=new Tentacules(moAE,att,lonT,correctionAngle);
    monstre[moAE].tentacule[monstre[moAE].nbTentacules-1]=tmpTentacules;
    undo[undoIndex]=2;
    undoIndex++;
    monstre[moAE].espVie+=70;
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbBrasP() {
  if (monstre[moAE].nbBras<10) {
    monstre[moAE].nbBras++;
    Bras tmpBras=new Bras(moAE,att,lonT,correctionAngle);
    monstre[moAE].bras[monstre[moAE].nbBras-1]=tmpBras;
    undo[undoIndex]=1;
    undoIndex++;
    monstre[moAE].espVie+=100;
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbYeuxAP() {
  if (monstre[moAE].nbYeuxA<10) {
    if (deprecated()) {
      lonT*=2;
    }       
    monstre[moAE].nbYeuxA++;
    YeuxA tmpYeuxA=new YeuxA(moAE,att,lonT,correctionAngle);
    monstre[moAE].oeilA[monstre[moAE].nbYeuxA-1]=tmpYeuxA;
    undo[undoIndex]=3;
    undoIndex++;
    monstre[moAE].espVie+=200;
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}

public void nbPicsP() {
  if (monstre[moAE].nbPics<10) {
    monstre[moAE].nbPics++;
    Pics tmpPics=new Pics(moAE,att,lonT,correctionAngle);
    monstre[moAE].pic[monstre[moAE].nbPics-1]=tmpPics;
    undo[undoIndex]=0;
    undoIndex++;
    monstre[moAE].espVie+=300;
    envoieSon(moAE);    
    cmMenuOn=false;    
  } 
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbQueuesP() {
  if (monstre[moAE].nbQueues<10) {
    monstre[moAE].nbQueues++;
    Queues tmpQueues=new Queues(moAE,att,lonT,correctionAngle);
    monstre[moAE].queue[monstre[moAE].nbQueues-1]=tmpQueues;
    undo[undoIndex]=2;
    undoIndex++;
    monstre[moAE].espVie+=70;
    envoieSon(moAE);    
    cmMenuOn=false;    
  } 
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbAilesP() {
  if (monstre[moAE].nbAiles<10) {
    monstre[moAE].nbAiles++;
    Ailes tmpAiles=new Ailes(moAE,att,lonT,correctionAngle);
    monstre[moAE].aile[monstre[moAE].nbAiles-1]=tmpAiles;
    undo[undoIndex]=1;
    undoIndex++;
    monstre[moAE].espVie+=100;
    envoieSon(moAE);    
    cmMenuOn=false;    
  } 
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbYeuxCP() {
  if (monstre[moAE].nbYeuxC<10) {
    monstre[moAE].nbYeuxC++;
    YeuxC tmpYeuxC=new YeuxC(moAE,att,lonT,correctionAngle);
    monstre[moAE].oeilC[monstre[moAE].nbYeuxC-1]=tmpYeuxC;
    undo[undoIndex]=3;
    undoIndex++;
    monstre[moAE].espVie+=200;
    envoieSon(moAE);    
    cmMenuOn=false;    
  } 
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}

public void nbCorpsP() {
  int dep=moAE;
  if (monstre[dep].nbCorps<10) {
    monstre[dep].nbCorps++;
    float x=xPrev-monstre[dep].corps[att].xR-mCX-debModelx;
    float y=yPrev-monstre[dep].corps[att].yR-mCY-debModely;
    Corps tmpCorps=new Corps(dep,att,x,y,valeurSet(dep,att,5,20));
    monstre[dep].corps[monstre[dep].nbCorps-1]=tmpCorps;
    monstre[dep].corps[monstre[dep].nbCorps-1].setAttache();
    undo[undoIndex]=0;
    undoIndex++;
    monstre[dep].espVie+=300;
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbBecsP() {
  int dep=moAE;
  if (monstre[dep].nbBecs<10) {
    monstre[dep].nbBecs++;
    float x=xPrev-monstre[dep].corps[att].xR-mCX-debModelx;
    float y=yPrev-monstre[dep].corps[att].yR-mCY-debModely;      
    Becs tmpBecs=new Becs(dep,att,x,y);
    monstre[dep].bec[monstre[dep].nbBecs-1]=tmpBecs;
    monstre[dep].bec[monstre[dep].nbBecs-1].setAttache();
    undo[undoIndex]=1;
    undoIndex++;
    monstre[dep].espVie+=100;
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbJambesP() {
  int dep=moAE;
  if (monstre[dep].nbJambes<10) {
    monstre[dep].nbJambes++;
    float x=xPrev-monstre[dep].corps[att].xR-mCX-debModelx;
    float y=yPrev-monstre[dep].corps[att].yR-mCY-debModely;        
    Jambes tmpJambes=new Jambes(dep,att,x,y);
    monstre[dep].jambe[monstre[dep].nbJambes-1]=tmpJambes;
    monstre[dep].jambe[monstre[dep].nbJambes-1].setAttache();
    undo[undoIndex]=2;
    undoIndex++;
    monstre[dep].espVie+=70;   
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1);    
  }  
}
public void nbYeuxP() {
  int dep=moAE;
  if (monstre[dep].nbYeux<10) {
    monstre[dep].nbYeux++;
    float x=xPrev-monstre[dep].corps[att].xR-mCX-debModelx;
    float y=yPrev-monstre[dep].corps[att].yR-mCY-debModely;          
    Yeux tmpYeux=new Yeux(dep,att,x,y,valeurSet(dep,att,5,30));
    monstre[dep].oeil[monstre[dep].nbYeux-1]=tmpYeux;
    monstre[dep].oeil[monstre[dep].nbYeux-1].setAttache();
    undo[undoIndex]=3;
    undoIndex++;
    monstre[dep].espVie+=200;
    envoieSon(moAE);    
    cmMenuOn=false;    
  }
  else{
    interditOn=true;
    sonDeprec(1); 
  }  
}

public void nbPicsM() {
  int dep=moAE;  
  if (monstre[dep].nbPics>0) {
    monstre[dep].nbPics--;
    undoIndex--;
    monstre[dep].espVie-=300;
  }
}
public void nbQueuesM() {
  int dep=moAE;  
  if (monstre[dep].nbQueues>0) {
    monstre[dep].nbQueues--;
    undoIndex--;
    monstre[dep].espVie-=70;
  }
}
public void nbAilesM() {
  int dep=moAE;  
  if (monstre[dep].nbAiles>0) {
    monstre[dep].nbAiles--;
    undoIndex--;
    monstre[dep].espVie-=100;
  }
}
public void nbYeuxCM() {
  int dep=moAE;  
  if (monstre[dep].nbYeuxC>0) {
    monstre[dep].nbYeuxC--;
    undoIndex--;
    monstre[dep].espVie-=200;
  }
}
public void nbCilsM() {
  int dep=moAE;  
  if (monstre[dep].nbCils>0) {
    monstre[dep].nbCils--;
    undoIndex--;
    monstre[dep].espVie-=300;
  }
}
public void nbTentaculesM() {
  int dep=moAE;  
  if (monstre[dep].nbTentacules>0) {
    monstre[dep].nbTentacules--;
    undoIndex--;
    monstre[dep].espVie-=70;
  }
}
public void nbBrasM() {
  int dep=moAE;  
  if (monstre[dep].nbBras>0) {
    monstre[dep].nbBras--;
    undoIndex--;
    monstre[dep].espVie-=100;
  }
}
public void nbYeuxAM() {
  int dep=moAE;  
  if (monstre[dep].nbYeuxA>0) {
    monstre[dep].nbYeuxA--;
    undoIndex--;
    monstre[dep].espVie-=200;
  }
}
public void nbCorpsM() {
  int dep=moAE;
  if (monstre[dep].nbCorps>1) {
    int anAtt=monstre[dep].nbCorps-1;
    int nvAtt=monstre[dep].corps[monstre[dep].nbCorps-1].att;
    for (int i=0;i<monstre[dep].nbBecs;i++) {
      if (monstre[dep].bec[i].att==anAtt) {
        monstre[dep].bec[i].att=nvAtt;
      }
    }
    for (int i=0;i<monstre[dep].nbYeux;i++) {
      if (monstre[dep].oeil[i].att==anAtt) {
        monstre[dep].oeil[i].att=nvAtt;
      }
    }
    for (int i=0;i<monstre[dep].nbJambes;i++) {
      if (monstre[dep].jambe[i].att==anAtt) {
        monstre[dep].jambe[i].att=nvAtt;
      }
    }
    monstre[dep].nbCorps--;
    undoIndex--;
    monstre[dep].espVie-=300;
  }
}
public void nbBecsM() {
  int dep=moAE;  
  if (monstre[dep].nbBecs>0) {
    monstre[dep].nbBecs--;
    undoIndex--;
    monstre[dep].espVie-=100;      
  }
}
public void nbJambesM() {
  int dep=moAE;  
  if (monstre[dep].nbJambes>0) {
    monstre[dep].nbJambes--;
    undoIndex--;
    monstre[dep].espVie-=70;
  }
}
public void nbYeuxM() {
  int dep=moAE;  
  if (monstre[dep].nbYeux>0) {
    monstre[dep].nbYeux--;
    undoIndex--;
    monstre[dep].espVie-=200;
  }
}

public void keyPressed() {
  if (!syncKeys)  {
    if (phase==4) {
      modifieNom();
    }
    if (keyCode==117) {//F6
      phase=0;
    }
    if (keyCode==118) {//F7
      if (afficheLeds) {
        afficheLeds=false;
      }
      else{
        afficheLeds=true;      
      }
    }
    if (keyCode==119) {//F8
      if (apercuvisible) {
        apercuvisible=false;
      }
      else{
        apercuvisible=true;      
      }
    }
    if (phase==0) {
      if (keyCode==113) {//F2
        reset();
        pMes("reset");        
      }
    }
    if (phase==1) {
      if (keyCode==66) {//b
        if (moAE!=-1) {
          envoieSon(moAE);
        }
      }
      if (keyCode==155) {//inser
        if (moAE!=-1) {
          undoIndex=0;
          monstre[moAE].sS=true;
          mAJmSSN();
          loadPopup();
          placeAuto();
          phase=4;
        }
      }      
      if (keyCode==80) {//P
        chargePays();
        loadPopup();
        phase=5;
      }    
      if (keyCode==114) {//F3
        if (moAE!=-1) {
          loadPopup();
          phase=7;
        }
      }
      if (keyCode==115) {//F4
        if (moAE!=-1) {
          if (monstre[moAE].type!=0) {
            if (monstre[moAE].sS==true) {
              monstre[moAE].sS=false;
            }
            else{    
              monstre[moAE].sS=true;
            }
          }
          mAJmSSN();
          placeAuto();
        }
      }
      if (keyCode==122) {//F11
        for (int i=0;i<nbMonstres;i++) {
          if (monstre[i].type!=0) {
            monstre[i].sS=true;
          }
        }
        mAJmSSN();
        placeAuto();
      }
      if (keyCode==123) {//F12
        for (int i=0;i<nbMonstres;i++) {
          if (monstre[i].type!=0) {
            monstre[i].sS=false;
          }
        }
        mAJmSSN();
        placeAuto();
      }    
      if (keyCode==116) {//F5
        phase=3;
        noCursor();
        mAJmSSN();
        placeAuto();
        besDescendre.teinte=pays[paysC].teinte;
        setDecors();
      }
      if (keyCode==49) {//1
        if (moAE!=-1) {
          monstre[moAE]=new MonstresA(moAE);
          monstre[moAE].sS=true;
        }
      }
      if (keyCode==50) {//2
        if (moAE!=-1) {    
          monstre[moAE]=new MonstresB(moAE);
          monstre[moAE].sS=true;   
        }
      }
      if (keyCode==51) {//3
        if (moAE!=-1) {    
          monstre[moAE]=new MonstresC(moAE);
          monstre[moAE].sS=true;    
        }
      }
      if (keyCode==52) {//4
        if (moAE!=-1) {    
          EditR();
        }
      }
      if (keyCode==37) {
        moAE=(moAE-1+nbMonstres)%nbMonstres;
      }
      if (keyCode==38) {
        moAE=(moAE-besCX+nbMonstres)%nbMonstres;
      }
      if (keyCode==39) {
        moAE=(moAE+1+nbMonstres)%nbMonstres;
      }
      if (keyCode==40) {
        moAE=(moAE+besCX+nbMonstres)%nbMonstres; 
      }      
    }
    else {  
      if (keyCode==116) {//F5  
        allerAuBestiaire();
      }
    }
    if (keyCode==127) {//suppr
      if (moAE!=-1) {
        monstre[moAE]=new MonstresMorts(moAE);
      }
    }
    if (phase==3) {
      if (keyCode==104) {
        reducScene*=0.9f;
      }  
      if (keyCode==98) {
        reducScene*=1.1f;    
      }          
      if (keyCode==37) {
        auClavier=true;
        float camBou=camPos-50;
        camPos=constrain((camBou+camPos)/2,0,sceLX-width);
      }
      if (keyCode==39) {
        auClavier=true;
        float camBou=camPos+50;
        camPos=constrain((camBou+camPos)/2,0,sceLX-width);
      }
      if (keyCode==38) {
        tempo-=1;
        tempo=constrain(tempo,1,10);      
        pMes("tempo +");        
      }
      if (keyCode==40) {
        tempo+=1;
        tempo=constrain(tempo,1,10);
        pMes("tempo -");
      }
      if (keyCode>48 && keyCode<49+nbPays) {//1
        chargePays();
        paysC=keyCode-49;
        tempo=pays[paysC].tempo;      
        sendGeneral();
      }    
      if (keyCode==67) {//c
        typeCurseur=(typeCurseur+1)%3;
      }
      if (keyCode==106) {//*
        tempoWaiter=0;
      }  
    }
    if (phase==5) {
      if (keyCode>48 && keyCode<49+nbPays) {//1
        paysC=keyCode-49;
        tempo=pays[paysC].tempo;      
        phase=1;
        sendGeneral();
      }
    }
    if (keyCode==33) {//pgup
      exportPNG=true;
      pMes("rec ON");
    }
    if (keyCode==34) {//pgdn
      exportPNG=false;
      pMes("rec OFF");    
    }
    if (keyCode==36) {
      undo();
    }
    if (phase!=4) {
      if (keyCode==83) {  //s
        saveTheFile()  ;
        pMes("sauvegarde");
      }      
      if (keyCode==75) {//k
        if (crisAct) {
          crisAct=false;
          pMes("cris OFF");
        }
        else{
          crisAct=true;      
          pMes("cris ON");          
        }
      }
      if (keyCode==76) {//l
        if (pasAct) {
          pasAct=false;
          pMes("bruits divers OFF");
        }
        else{
          pasAct=true;      
          pMes("bruits divers ON");
        }
      }  
      if (keyCode==77) {//m
        if (paysAct) {
          paysAct=false;
          pMes("bgsounds OFF");
        }
        else{
          paysAct=true;      
          pMes("bgsounds ON");          
        }
      }
      if (keyCode==109) {//-
        if (tempoDefile) {
          tempoDefile=false;
          pMes("beat auto OFF");          
        }
        else{
          tempoDefile=true;      
          pMes("beat auto ON");
        }
      }
    }  
    if (keyCode == TAB) {
      save("save/screen.tif");
    }    
  }
  if (phase!=4) {
    if (keyCode==107) {//+
      if (syncKeys) {
        syncKeys=false;
        pMes("sync OFF");
      }
      else{
        mAJmSSN();        
        syncKeys=true;
        pMes("sync ON");
      }
    }    
    if (syncKeys) {    
      syncKcompute();
    }
  }
  if (phase==0) {
    keyPresIntro();
  }
  if (keyCode==35) {
    langue+=1;
    langue=langue%nbLangues;
  }
}

public void pMes(String mes) {
  afficheMes=10;
  message=mes;
}

public void fight(int nb1, int nb2) {
  int moAE2;
  if (monstre[nb1].taille>monstre[nb2].taille) {
    moAE=nb1;
    moAE2=nb2;
  }
  else{
    moAE=nb2;
    moAE2=nb1;
  }
  if (monstre[moAE].type==1) {
    int nvNbCils=ceil((monstre[moAE].nbCils+monstre[moAE2].nbCils)/2);//nombre de corps
    int nvNbTentacules=ceil((monstre[moAE].nbTentacules+monstre[moAE2].nbTentacules)/2);//nombre de jambes
    int nvNbBras=ceil((monstre[moAE].nbBras+monstre[moAE2].nbBras)/2);//nombre d'yeux
    int nvNbYeuxA=ceil((monstre[moAE].nbYeuxA+monstre[moAE2].nbYeuxA)/2);//nombre de becs
    int iMT;//index du membre (temporaire)
    while (monstre[moAE].nbCils<nvNbCils) {
      monstre[moAE].espVie+=150;
      monstre[moAE].nbCils++;
      iMT=monstre[moAE].nbCils-1;
      int att=monstre[moAE2].cil[iMT].att;
      float l=monstre[moAE2].cil[iMT].l;
      float corr=monstre[moAE2].cil[iMT].corr;
      monstre[moAE].cil[iMT]= new Cils(moAE, att, l, corr);
    }
    while (monstre[moAE].nbTentacules<nvNbTentacules) {
      monstre[moAE].espVie+=35;
      monstre[moAE].nbTentacules++;
      iMT=monstre[moAE].nbTentacules-1;
      int att=monstre[moAE2].tentacule[iMT].att;
      float l=monstre[moAE2].tentacule[iMT].l;
      float corr=monstre[moAE2].tentacule[iMT].corr;
      monstre[moAE].tentacule[iMT]= new Tentacules(moAE, att, l, corr);
    }
    while (monstre[moAE].nbBras<nvNbBras) {
      monstre[moAE].espVie+=50;
      monstre[moAE].nbBras++;
      iMT=monstre[moAE].nbBras-1;
      int att=monstre[moAE2].bras[iMT].att;
      float l=monstre[moAE2].bras[iMT].l;
      float corr=monstre[moAE2].bras[iMT].corr;
      monstre[moAE].bras[iMT]= new Bras(moAE, att, l, corr);
    }
    while (monstre[moAE].nbYeuxA<nvNbYeuxA) {
      monstre[moAE].espVie+=100;
      monstre[moAE].nbYeuxA++;
      iMT=monstre[moAE].nbYeuxA-1;
      int att=monstre[moAE2].oeilA[iMT].att;
      float l=monstre[moAE2].oeilA[iMT].l;
      float corr=monstre[moAE2].oeilA[iMT].corr;
      monstre[moAE].oeilA[iMT]= new YeuxA(moAE, att, l, corr);
    }
  }
  if (monstre[moAE].type==2) {
    int nvNbCorps=ceil((monstre[moAE].nbCorps+monstre[moAE2].nbCorps)/2);//nombre de corps
    int nvNbJambes=ceil((monstre[moAE].nbJambes+monstre[moAE2].nbJambes)/2);//nombre de jambes
    int nvNbYeux=ceil((monstre[moAE].nbYeux+monstre[moAE2].nbYeux)/2);//nombre d'yeux
    int nvNbBecs=ceil((monstre[moAE].nbBecs+monstre[moAE2].nbBecs)/2);//nombre de becs
    int iMT;//index du membre (temporaire)
    while (monstre[moAE].nbCorps<nvNbCorps) {
      monstre[moAE].espVie+=150;
      monstre[moAE].nbCorps++;
      iMT=monstre[moAE].nbCorps-1;
      float x=monstre[moAE2].corps[iMT].x;
      float y=monstre[moAE2].corps[iMT].y;
      float r=monstre[moAE2].corps[iMT].r;
      int att=constrain(monstre[moAE2].corps[iMT].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].corps[iMT]= new Corps(moAE, att, x, y, r);
    }
    while (monstre[moAE].nbJambes<nvNbJambes) {
      monstre[moAE].espVie+=35;      
      monstre[moAE].nbJambes++;
      iMT=monstre[moAE].nbJambes-1;
      float x=monstre[moAE2].jambe[iMT].x;
      float y=monstre[moAE2].jambe[iMT].yEntree;
      int att=constrain(monstre[moAE2].jambe[iMT].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].jambe[iMT]= new Jambes(moAE, att, x, y);
    }
    while (monstre[moAE].nbYeux<nvNbYeux) {
      monstre[moAE].espVie+=100;      
      monstre[moAE].nbYeux++;
      iMT=monstre[moAE].nbYeux-1;
      float x=monstre[moAE2].oeil[iMT].x;
      float y=monstre[moAE2].oeil[iMT].y;
      float r=monstre[moAE2].oeil[iMT].r;
      int att=constrain(monstre[moAE2].oeil[iMT].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].oeil[iMT]= new Yeux(moAE, att, x, y, r);
    }
    while (monstre[moAE].nbBecs<nvNbBecs) {
      monstre[moAE].espVie+=50;      
      monstre[moAE].nbBecs++;
      iMT=monstre[moAE].nbBecs-1;
      float x=monstre[moAE2].bec[iMT].x;
      float y=monstre[moAE2].bec[iMT].y;
      int att=constrain(monstre[moAE2].bec[iMT].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].bec[iMT]= new Becs(moAE, att, x, y);
    }
    for (int i=0;i<monstre[moAE].nbCorps;i++) {
      monstre[moAE].corps[i].att=constrain(monstre[moAE].corps[i].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].corps[i].depend=moAE;
    }
    for (int i=0;i<monstre[moAE].nbJambes;i++) {
      monstre[moAE].jambe[i].att=constrain(monstre[moAE].jambe[i].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].jambe[i].depend=moAE;    
    }
    for (int i=0;i<monstre[moAE].nbYeux;i++) {
      monstre[moAE].oeil[i].att=constrain(monstre[moAE].oeil[i].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].oeil[i].depend=moAE;    
    }
    for (int i=0;i<monstre[moAE].nbBecs;i++) {
      monstre[moAE].bec[i].att=constrain(monstre[moAE].bec[i].att,0,monstre[moAE].nbCorps-1);
      monstre[moAE].bec[i].depend=moAE;
    }
  }
  if (monstre[moAE].type==3) {
    int nvNbPics=ceil((monstre[moAE].nbPics+monstre[moAE2].nbPics)/2);//nombre de corps
    int nvNbQueues=ceil((monstre[moAE].nbQueues+monstre[moAE2].nbQueues)/2);//nombre de jambes
    int nvNbAiles=ceil((monstre[moAE].nbAiles+monstre[moAE2].nbAiles)/2);//nombre d'yeux
    int nvNbYeuxC=ceil((monstre[moAE].nbYeuxC+monstre[moAE2].nbYeuxC)/2);//nombre de becs
    int iMT;//index du membre (temporaire)
    while (monstre[moAE].nbPics<nvNbPics) {
      monstre[moAE].espVie+=150;      
      monstre[moAE].nbPics++;
      iMT=monstre[moAE].nbPics-1;
      int att=monstre[moAE2].pic[iMT].att;
      float l=monstre[moAE2].pic[iMT].l;
      float corr=monstre[moAE2].pic[iMT].corr;
      monstre[moAE].pic[iMT]= new Pics(moAE, att, l, corr);
    }
    while (monstre[moAE].nbQueues<nvNbQueues) {
      monstre[moAE].espVie+=35;
      monstre[moAE].nbQueues++;
      iMT=monstre[moAE].nbQueues-1;
      int att=monstre[moAE2].queue[iMT].att;
      float l=monstre[moAE2].queue[iMT].l;
      float corr=monstre[moAE2].queue[iMT].corr;
      monstre[moAE].queue[iMT]= new Queues(moAE, att, l, corr);
    }
    while (monstre[moAE].nbAiles<nvNbAiles) {
      monstre[moAE].espVie+=50;
      monstre[moAE].nbAiles++;
      iMT=monstre[moAE].nbAiles-1;
      int att=monstre[moAE2].aile[iMT].att;
      float l=monstre[moAE2].aile[iMT].l;
      float corr=monstre[moAE2].aile[iMT].corr;
      monstre[moAE].aile[iMT]= new Ailes(moAE, att, l, corr);
    }
    while (monstre[moAE].nbYeuxC<nvNbYeuxC) {
      monstre[moAE].espVie+=100;
      monstre[moAE].nbYeuxC++;
      iMT=monstre[moAE].nbYeuxC-1;
      int att=monstre[moAE2].oeilC[iMT].att;
      float l=monstre[moAE2].oeilC[iMT].l;
      float corr=monstre[moAE2].oeilC[iMT].corr;
      monstre[moAE].oeilC[iMT]= new YeuxC(moAE, att, l, corr);
    }
  }
  monstre[moAE2]=new MonstresMorts(moAE2);
}

public int caseVide() {
  int value=-1;
  for (int i=0;i<nbMonstres && value==-1;i++) {
    if (monstre[i].type==0) {
      value=i;
    }
  }
  return value;
}

public void hybride(int nb1, int nb2) {
  moAE=caseVide();
  if (moAE!=-1) {
    if (monstre[nb1].type==1) {
      monstre[moAE]=new MonstresA(moAE);
    }
    if (monstre[nb1].type==2) {
      monstre[moAE]=new MonstresB(moAE);
    }
    if (monstre[nb1].type==3) {
      monstre[moAE]=new MonstresC(moAE);
    }
    monstre[moAE].taille=0;
    monstre[moAE].sS=true;
    monstre[moAE].x=(monstre[nb1].x+monstre[nb2].x)/2;
    monstre[moAE].y=(monstre[nb1].y+monstre[nb2].y)/2;
    monstre[moAE].plan=monstre[moAE].type-1;
    monstre[moAE].nom=monstre[nb1].nom.substring(0,floor(monstre[nb1].nom.length()/2));
    monstre[moAE].nom+=monstre[nb2].nom.substring(floor(monstre[nb2].nom.length()/2),monstre[nb2].nom.length());
    String nomTemp=monstre[moAE].nom;
    monstre[moAE].nom="";    
    for (int i=0;i<nomTemp.length();i++) {
      if (i==0) {
        monstre[moAE].nom+=nomTemp.substring(i,i+1).toUpperCase();
      }
      else{
        monstre[moAE].nom+=nomTemp.substring(i,i+1).toLowerCase();
      }
    }
    if (monstre[moAE].type==1) {
      for (int i=0;i<nbBourses;i++) {
        monstre[moAE].bourseL[i]=(monstre[nb1].bourseL[i]+monstre[nb2].bourseL[i])/2;
        monstre[moAE].bourseR[i]=monstre[nb1].bourseR[i]+vrMax(monstre[nb1].bourseR[i],monstre[nb2].bourseR[i],TWO_PI)/2;
      }
      int nvNbCils=ceil((monstre[nb1].nbCils+monstre[nb2].nbCils)/2);//nombre de Pics
      int nvNbTentacules=ceil((monstre[nb1].nbTentacules+monstre[nb2].nbTentacules)/2);//nombre de queues
      int nvNbBras=ceil((monstre[nb1].nbBras+monstre[nb2].nbBras)/2);//nombre de ailes
      int nvNbYeuxA=ceil((monstre[nb1].nbYeuxA+monstre[nb2].nbYeuxA)/2);//nombre d'yeux      
      int iMT;//index du membre (temporaire)
      while (monstre[moAE].nbCils<nvNbCils) {
        monstre[moAE].espVie+=300;
        monstre[moAE].nbCils++;
        iMT=monstre[moAE].nbCils-1;
        if (monstre[nb1].nbCils>=monstre[moAE].nbCils) {//1+2
          if (monstre[nb2].nbCils>=monstre[moAE].nbCils) {
            int att=floor((monstre[nb1].cil[iMT].att+monstre[nb2].cil[iMT].att)/2);
            float l=(monstre[nb1].cil[iMT].l+monstre[nb2].cil[iMT].l)/2;
            float corr=(monstre[nb1].cil[iMT].corr+monstre[nb2].cil[iMT].corr)/2;
            monstre[moAE].cil[iMT]=new Cils(moAE, att, l, corr);
          }
          else{//que 1
            int att=monstre[nb1].cil[iMT].att;
            float l=monstre[nb1].cil[iMT].l;
            float corr=monstre[nb1].cil[iMT].corr;
            monstre[moAE].cil[iMT]=new Cils(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].cil[iMT].att;
          float l=monstre[nb2].cil[iMT].l;
          float corr=monstre[nb2].cil[iMT].corr;
          monstre[moAE].cil[iMT]=new Cils(moAE, att, l, corr);        
        }
      }
      while (monstre[moAE].nbTentacules<nvNbTentacules) {
        monstre[moAE].espVie+=70;        
        monstre[moAE].nbTentacules++;
        iMT=monstre[moAE].nbTentacules-1;
        if (monstre[nb1].nbTentacules>=monstre[moAE].nbTentacules) {//1+2
          if (monstre[nb2].nbTentacules>=monstre[moAE].nbTentacules) {
            int att=floor((monstre[nb1].tentacule[iMT].att+monstre[nb2].tentacule[iMT].att)/2);
            float l=(monstre[nb1].tentacule[iMT].l+monstre[nb2].tentacule[iMT].l)/2;
            float corr=(monstre[nb1].tentacule[iMT].corr+monstre[nb2].tentacule[iMT].corr)/2;
            monstre[moAE].tentacule[iMT]=new Tentacules(moAE, att, l, corr);          
          }
          else{//que 1
            int att=monstre[nb1].tentacule[iMT].att;
            float l=monstre[nb1].tentacule[iMT].l;
            float corr=monstre[nb1].tentacule[iMT].corr;
            monstre[moAE].tentacule[iMT]=new Tentacules(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].tentacule[iMT].att;
          float l=monstre[nb2].tentacule[iMT].l;
          float corr=monstre[nb2].tentacule[iMT].corr;
          monstre[moAE].tentacule[iMT]=new Tentacules(moAE, att, l, corr);        
        }
      }
      while (monstre[moAE].nbBras<nvNbBras) {
        monstre[moAE].espVie+=100;        
        monstre[moAE].nbBras++;
        iMT=monstre[moAE].nbBras-1;
        if (monstre[nb1].nbBras>=monstre[moAE].nbBras) {//1+2
          if (monstre[nb2].nbBras>=monstre[moAE].nbBras) {
            int att=floor((monstre[nb1].bras[iMT].att+monstre[nb2].bras[iMT].att)/2);
            float l=(monstre[nb1].bras[iMT].l+monstre[nb2].bras[iMT].l)/2;
            float corr=(monstre[nb1].bras[iMT].corr+monstre[nb2].bras[iMT].corr)/2;
            monstre[moAE].bras[iMT]=new Bras(moAE, att, l, corr);          
          }
          else{//que 1
            int att=monstre[nb1].bras[iMT].att;
            float l=monstre[nb1].bras[iMT].l;
            float corr=monstre[nb1].bras[iMT].corr;
            monstre[moAE].bras[iMT]=new Bras(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].bras[iMT].att;
          float l=monstre[nb2].bras[iMT].l;
          float corr=monstre[nb2].bras[iMT].corr;
          monstre[moAE].bras[iMT]=new Bras(moAE, att, l, corr);
        }
      }
      while (monstre[moAE].nbYeuxA<nvNbYeuxA) {
        monstre[moAE].espVie+=200;
        monstre[moAE].nbYeuxA++;
        iMT=monstre[moAE].nbYeuxA-1;
        if (monstre[nb1].nbYeuxA>=monstre[moAE].nbYeuxA) {//1+2
          if (monstre[nb2].nbYeuxA>=monstre[moAE].nbYeuxA) {
            int att=floor((monstre[nb1].oeilA[iMT].att+monstre[nb2].oeilA[iMT].att)/2);
            float l=(monstre[nb1].oeilA[iMT].l+monstre[nb2].oeilA[iMT].l)/2;
            float corr=(monstre[nb1].oeilA[iMT].corr+monstre[nb2].oeilA[iMT].corr)/2;
            monstre[moAE].oeilA[iMT]=new YeuxA(moAE, att, l, corr);
          }
          else{//que 1
            int att=monstre[nb1].oeilA[iMT].att;
            float l=monstre[nb1].oeilA[iMT].l;
            float corr=monstre[nb1].oeilA[iMT].corr;
            monstre[moAE].oeilA[iMT]=new YeuxA(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].oeilA[iMT].att;
          float l=monstre[nb2].oeilA[iMT].l;
          float corr=monstre[nb2].oeilA[iMT].corr;
          monstre[moAE].oeilA[iMT]=new YeuxA(moAE, att, l, corr);
        }
      }
    }    
    if (monstre[moAE].type==2) {
      int nvNbCorps=ceil((monstre[nb1].nbCorps+monstre[nb2].nbCorps)/2);//nombre de corps
      int nvNbJambes=ceil((monstre[nb1].nbJambes+monstre[nb2].nbJambes)/2);//nombre de jambes
      int nvNbYeux=ceil((monstre[nb1].nbYeux+monstre[nb2].nbYeux)/2);//nombre d'yeux
      int nvNbBecs=ceil((monstre[nb1].nbBecs+monstre[nb2].nbBecs)/2);//nombre de becs
      int iMT;//index du membre (temporaire)
      while (monstre[moAE].nbCorps<nvNbCorps) {
        monstre[moAE].espVie+=300;
        monstre[moAE].nbCorps++;
        iMT=monstre[moAE].nbCorps-1;
        if (monstre[nb1].nbCorps>=monstre[moAE].nbCorps) {//1+2
          if (monstre[nb2].nbCorps>=monstre[moAE].nbCorps) {
            float x=(monstre[nb1].corps[iMT].x+monstre[nb2].corps[iMT].x)/2;
            float y=(monstre[nb1].corps[iMT].y+monstre[nb2].corps[iMT].y)/2;
            float r=(monstre[nb1].corps[iMT].r+monstre[nb2].corps[iMT].r)/2;
            int att=constrain(max(monstre[nb1].corps[iMT].att,monstre[nb2].corps[iMT].att),0,monstre[moAE].nbCorps-1);
            monstre[moAE].corps[iMT]=new Corps(moAE, att, x, y, r);
          }
          else{//que 1
            float x=monstre[nb1].corps[iMT].x;
            float y=monstre[nb1].corps[iMT].y;
            float r=monstre[nb1].corps[iMT].r;
            int att=constrain(monstre[nb1].corps[iMT].att,0,monstre[moAE].nbCorps-1);
            monstre[moAE].corps[iMT]=new Corps(moAE, att, x, y, r);          
          }
        }
        else {//que 2
          float x=monstre[nb2].corps[iMT].x;
          float y=monstre[nb2].corps[iMT].y;
          float r=monstre[nb2].corps[iMT].r;
          int att=constrain(monstre[nb2].corps[iMT].att,0,monstre[moAE].nbCorps-1);
          monstre[moAE].corps[iMT]=new Corps(moAE, att, x, y, r);        
        }
        monstre[moAE].corps[iMT].setAttache();
        monstre[moAE].corps[iMT].xR=monstre[moAE].corps[iMT].attX+monstre[moAE].corps[iMT].x;
        monstre[moAE].corps[iMT].yR=monstre[moAE].corps[iMT].attY+monstre[moAE].corps[iMT].y;
      }
      while (monstre[moAE].nbJambes<nvNbJambes) {
        monstre[moAE].espVie+=70;
        monstre[moAE].nbJambes++;
        iMT=monstre[moAE].nbJambes-1;
        if (monstre[nb1].nbJambes>=monstre[moAE].nbJambes) {
          if (monstre[nb2].nbJambes>=monstre[moAE].nbJambes) {//1+2
            float x=(monstre[nb1].jambe[iMT].x+monstre[nb2].jambe[iMT].x)/2;
            float y=(monstre[nb1].jambe[iMT].yEntree+monstre[nb2].jambe[iMT].yEntree)/2;
            int att=constrain(max(monstre[nb1].jambe[iMT].att,monstre[nb2].jambe[iMT].att),0,monstre[moAE].nbCorps-1);
            monstre[moAE].jambe[iMT]=new Jambes(moAE, att, x, y);          
          }
          else{//que 1
            float x=monstre[nb1].jambe[iMT].x;
            float y=monstre[nb1].jambe[iMT].yEntree;
            int att=constrain(monstre[nb1].jambe[iMT].att,0,monstre[moAE].nbCorps-1);
            monstre[moAE].jambe[iMT]=new Jambes(moAE, att, x, y);
          }
        }
        else {
          float x=monstre[nb2].jambe[iMT].x;
          float y=monstre[nb2].jambe[iMT].yEntree;
          int att=constrain(monstre[nb2].jambe[iMT].att,0,monstre[moAE].nbCorps-1);
          monstre[moAE].jambe[iMT]=new Jambes(moAE, att, x, y);
        }
      }
      while (monstre[moAE].nbYeux<nvNbYeux) {
        monstre[moAE].espVie+=200;        
        monstre[moAE].nbYeux++;
        iMT=monstre[moAE].nbYeux-1;
        if (monstre[nb1].nbYeux>=monstre[moAE].nbYeux) {
          if (monstre[nb2].nbYeux>=monstre[moAE].nbYeux) {//1+2
            float x=(monstre[nb1].oeil[iMT].x+monstre[nb2].oeil[iMT].x)/2;
            float y=(monstre[nb1].oeil[iMT].y+monstre[nb2].oeil[iMT].y)/2;
            float r=(monstre[nb1].oeil[iMT].r+monstre[nb2].oeil[iMT].r)/2;
            int att=constrain(max(monstre[nb1].oeil[iMT].att,monstre[nb2].oeil[iMT].att),0,monstre[moAE].nbCorps-1);
            monstre[moAE].oeil[iMT]=new Yeux(moAE, att, x, y, r);          
          }
          else{//que 1
            float x=monstre[nb1].oeil[iMT].x;
            float y=monstre[nb1].oeil[iMT].y;
            float r=monstre[nb1].oeil[iMT].r;
            int att=constrain(monstre[nb1].oeil[iMT].att,0,monstre[moAE].nbCorps-1);
            monstre[moAE].oeil[iMT]=new Yeux(moAE, att, x, y, r);          
          }
        }
        else {//que 2
          float x=monstre[nb2].oeil[iMT].x;
          float y=monstre[nb2].oeil[iMT].y;
          float r=monstre[nb2].oeil[iMT].r;
          int att=constrain(monstre[nb2].oeil[iMT].att,0,monstre[moAE].nbCorps-1);
          monstre[moAE].oeil[iMT]=new Yeux(moAE, att, x, y, r);        
        }
      }
      while (monstre[moAE].nbBecs<nvNbBecs) {
        monstre[moAE].espVie+=100;        
        monstre[moAE].nbBecs++;
        iMT=monstre[moAE].nbBecs-1;
        if (monstre[nb1].nbBecs>=monstre[moAE].nbBecs) {
          if (monstre[nb2].nbBecs>=monstre[moAE].nbBecs) {//1+2
            float x=(monstre[nb1].bec[iMT].x+monstre[nb2].bec[iMT].x)/2;
            float y=(monstre[nb1].bec[iMT].y+monstre[nb2].bec[iMT].y)/2;
            int att=constrain(max(monstre[nb1].bec[iMT].att,monstre[nb2].bec[iMT].att),0,monstre[moAE].nbCorps-1);
            monstre[moAE].bec[iMT]=new Becs(moAE, att, x, y);          
          }
          else{//que 1
            float x=monstre[nb1].bec[iMT].x;
            float y=monstre[nb1].bec[iMT].y;
            int att=constrain(monstre[nb1].bec[iMT].att,0,monstre[moAE].nbCorps-1);
            monstre[moAE].bec[iMT]=new Becs(moAE, att, x, y);          
          }
        }
        else {//que 2
          float x=monstre[nb2].bec[iMT].x;
          float y=monstre[nb2].bec[iMT].y;
          int att=constrain(monstre[nb2].bec[iMT].att,0,monstre[moAE].nbCorps-1);
          monstre[moAE].bec[iMT]=new Becs(moAE, att, x, y);        
        }
      }
    }
    if (monstre[moAE].type==3) {
      for (int i=0;i<nbVertebres;i++) {
        monstre[moAE].gVert[i]=(monstre[nb1].gVert[i]+monstre[nb2].gVert[i])/2;
      }
      int nvNbPics=ceil((monstre[nb1].nbPics+monstre[nb2].nbPics)/2);//nombre de Pics
      int nvNbQueues=ceil((monstre[nb1].nbQueues+monstre[nb2].nbQueues)/2);//nombre de queues
      int nvNbYeuxC=ceil((monstre[nb1].nbYeuxC+monstre[nb2].nbYeuxC)/2);//nombre d'yeux
      int nvNbAiles=ceil((monstre[nb1].nbAiles+monstre[nb2].nbAiles)/2);//nombre de ailes
      int iMT;//index du membre (temporaire)
      while (monstre[moAE].nbPics<nvNbPics) {
        monstre[moAE].espVie+=300;        
        monstre[moAE].nbPics++;
        iMT=monstre[moAE].nbPics-1;
        if (monstre[nb1].nbPics>=monstre[moAE].nbPics) {//1+2
          if (monstre[nb2].nbPics>=monstre[moAE].nbPics) {
            int att=floor((monstre[nb1].pic[iMT].att+monstre[nb2].pic[iMT].att)/2);
            float l=(monstre[nb1].pic[iMT].l+monstre[nb2].pic[iMT].l)/2;
            float corr=(monstre[nb1].pic[iMT].corr+monstre[nb2].pic[iMT].corr)/2;
            monstre[moAE].pic[iMT]=new Pics(moAE, att, l, corr);
          }
          else{//que 1
            int att=monstre[nb1].pic[iMT].att;
            float l=monstre[nb1].pic[iMT].l;
            float corr=monstre[nb1].pic[iMT].corr;
            monstre[moAE].pic[iMT]=new Pics(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].pic[iMT].att;
          float l=monstre[nb2].pic[iMT].l;
          float corr=monstre[nb2].pic[iMT].corr;
          monstre[moAE].pic[iMT]=new Pics(moAE, att, l, corr);        
        }
      }
      while (monstre[moAE].nbQueues<nvNbQueues) {
        monstre[moAE].espVie+=70;        
        monstre[moAE].nbQueues++;
        iMT=monstre[moAE].nbQueues-1;
        if (monstre[nb1].nbQueues>=monstre[moAE].nbQueues) {//1+2
          if (monstre[nb2].nbQueues>=monstre[moAE].nbQueues) {
            int att=floor((monstre[nb1].queue[iMT].att+monstre[nb2].queue[iMT].att)/2);
            float l=(monstre[nb1].queue[iMT].l+monstre[nb2].queue[iMT].l)/2;
            float corr=(monstre[nb1].queue[iMT].corr+monstre[nb2].queue[iMT].corr)/2;
            monstre[moAE].queue[iMT]=new Queues(moAE, att, l, corr);          
          }
          else{//que 1
            int att=monstre[nb1].queue[iMT].att;
            float l=monstre[nb1].queue[iMT].l;
            float corr=monstre[nb1].queue[iMT].corr;
            monstre[moAE].queue[iMT]=new Queues(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].queue[iMT].att;
          float l=monstre[nb2].queue[iMT].l;
          float corr=monstre[nb2].queue[iMT].corr;
          monstre[moAE].queue[iMT]=new Queues(moAE, att, l, corr);        
        }
      }
      while (monstre[moAE].nbAiles<nvNbAiles) {
        monstre[moAE].espVie+=100;        
        monstre[moAE].nbAiles++;
        iMT=monstre[moAE].nbAiles-1;
        if (monstre[nb1].nbAiles>=monstre[moAE].nbAiles) {//1+2
          if (monstre[nb2].nbAiles>=monstre[moAE].nbAiles) {
            int att=floor((monstre[nb1].aile[iMT].att+monstre[nb2].aile[iMT].att)/2);
            float l=(monstre[nb1].aile[iMT].l+monstre[nb2].aile[iMT].l)/2;
            float corr=(monstre[nb1].aile[iMT].corr+monstre[nb2].aile[iMT].corr)/2;
            monstre[moAE].aile[iMT]=new Ailes(moAE, att, l, corr);          
          }
          else{//que 1
            int att=monstre[nb1].aile[iMT].att;
            float l=monstre[nb1].aile[iMT].l;
            float corr=monstre[nb1].aile[iMT].corr;
            monstre[moAE].aile[iMT]=new Ailes(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].aile[iMT].att;
          float l=monstre[nb2].aile[iMT].l;
          float corr=monstre[nb2].aile[iMT].corr;
          monstre[moAE].aile[iMT]=new Ailes(moAE, att, l, corr);
        }
      }
      while (monstre[moAE].nbYeuxC<nvNbYeuxC) {
        monstre[moAE].espVie+=200;
        monstre[moAE].nbYeuxC++;
        iMT=monstre[moAE].nbYeuxC-1;
        if (monstre[nb1].nbYeuxC>=monstre[moAE].nbYeuxC) {//1+2
          if (monstre[nb2].nbYeuxC>=monstre[moAE].nbYeuxC) {
            int att=floor((monstre[nb1].oeilC[iMT].att+monstre[nb2].oeilC[iMT].att)/2);
            float l=(monstre[nb1].oeilC[iMT].l+monstre[nb2].oeilC[iMT].l)/2;
            float corr=(monstre[nb1].oeilC[iMT].corr+monstre[nb2].oeilC[iMT].corr)/2;
            monstre[moAE].oeilC[iMT]=new YeuxC(moAE, att, l, corr);
          }
          else{//que 1
            int att=monstre[nb1].oeilC[iMT].att;
            float l=monstre[nb1].oeilC[iMT].l;
            float corr=monstre[nb1].oeilC[iMT].corr;
            monstre[moAE].oeilC[iMT]=new YeuxC(moAE, att, l, corr);
          }
        }
        else {//que 2
          int att=monstre[nb2].oeilC[iMT].att;
          float l=monstre[nb2].oeilC[iMT].l;
          float corr=monstre[nb2].oeilC[iMT].corr;
          monstre[moAE].oeilC[iMT]=new YeuxC(moAE, att, l, corr);
        }
      }
    }
  }
}

Boutons nomRetour = new Boutons("OK",sizx/2-50, sizy/2+35, 100, 50, 5, 200, 60, 60, 100, 150);

public void phaseE() {// phase = 4
  recouvreE();
  afficheNomGros();
}

public void recouvreE() {
  image(fondPopUp,0,0);
  noStroke();
  fill(0);
  rect(width/15,height/2-height/5,width-width/15,height*2/5);
  fill(200,60,100);
  textFont(font[2], 30);
  textAlign(CENTER,CENTER);
  if (langue==0) {
  text("entrez un nom",width/2,height/2-50);
  }
  if (langue==1) {
  text("name the beast",width/2,height/2-50);
  }  
  nomRetour.dessine();
}

public void afficheNomGros() {
  fill(200,60,120);
  textFont(font[3], 30);
  textAlign(CENTER,CENTER);
  text(monstre[moAE].nom, width/2, height/2);
}

public void modifieNom() {
  if (keyCode==8) {
    if (monstre[moAE].nom.length()>0) {
      monstre[moAE].nom=monstre[moAE].nom.substring(0,monstre[moAE].nom.length()-1);
    }
  }
  else if (key==ENTER || key==RETURN) {
    phase=1;
  }
  else{
    if (monstre[moAE].nom.length()<16) {
      boolean ok=false;
      for (int i2=0;i2<lettres.length();i2++) {
        if (key==lettres.charAt(i2) || key==lettres.toUpperCase().charAt(i2)) {
          ok=true;
        }
      }
      if (ok) {
        monstre[moAE].nom=monstre[moAE].nom+key;
      }
    }
  }
}

public void sourisPhaseE() {
  if (nomRetour.actif()==true) {
    phase=1;
  }
}

public void vireLesEspaces() {
  if (moAE!=-1) {
    boolean ok=false;
    String nomTmp=monstre[moAE].nom;
    for (int i=0;i<monstre[moAE].nom.length() && !ok; i++) {
      for (int i2=0;i2<lettres.length();i2++) {
        if (monstre[moAE].nom.charAt(i)==lettres.charAt(i2) || monstre[moAE].nom.charAt(i)==lettres.toUpperCase().charAt(i2)) {
          ok=true;
        }
      }
      if (!ok) {
        nomTmp=nomTmp.substring(1,nomTmp.length());
      }
    }
    monstre[moAE].nom=nomTmp;
    println(monstre[moAE].nom);
  }
}

SDrop drop = new SDrop(this);

Boutons exImporter =new Boutons("Importer",sizx/3,sizy/5*1,sizx/3,sizy/5,5,50,100,150,100,150);
Boutons exExporter =new Boutons("Exporter",sizx/3,sizy/5*3,sizx/3,sizy/5,5,50,100,150,100,150);

boolean waitForDrop=false;
boolean waitForPDrop=false;

public void phaseH() {
  recouvreH();
}

public void recouvreH() {
  if (waitForDrop==true) {  
    image(fondPopUp,0,0);
    fill(0);
    rect(sizx/5,sizy/3,sizx/5*3,sizy/3*1);
    fill(50,128,128);
    textFont(font[1], 20);
    textAlign(CENTER,CENTER);
    text("Drag & drop un monstre ici", width/2, height/2);
  }
  else{
    image(fondPopUp,0,0);
    fill(0);
    rect(sizx/4,sizy/6,sizx/4*2,sizy/6*4);
    exImporter.dessine();
    exExporter.dessine();
  }
}

public void sourisPhaseH() {
  if (waitForDrop==true) {
  }
  else {
    if (exImporter.actif()==true) {
      waitForDrop=true;
    }
    if (exExporter.actif()==true) {
      exporteM();
      phase=1;
    }
  }
}

public void exporteM() {
  PrintWriter besExport;
  besExport = createWriter("/data/"+monstre[moAE].nom+".mon");
  besExport.println(monstre[moAE].nom);
  besExport.println(monstre[moAE].type);
  besExport.println(monstre[moAE].nbCorps);
  besExport.println(monstre[moAE].nbJambes);
  besExport.println(monstre[moAE].nbYeux);
  besExport.println(monstre[moAE].nbBecs);
  besExport.println(monstre[moAE].taille);
  besExport.println(monstre[moAE].espVie);
  besExport.println(monstre[moAE].nb);
  besExport.println(monstre[moAE].tmpDecision);
  for (int i2=0;i2<monstre[moAE].nbCorps;i2++) {
    besExport.println(monstre[moAE].corps[i2].depend);
    besExport.println(monstre[moAE].corps[i2].x);
    besExport.println(monstre[moAE].corps[i2].y);
    besExport.println(monstre[moAE].corps[i2].att);    
    besExport.println(monstre[moAE].corps[i2].r);    
  }
  for (int i2=0;i2<monstre[moAE].nbJambes;i2++) {      
    besExport.println(monstre[moAE].jambe[i2].depend);
    besExport.println(monstre[moAE].jambe[i2].x);
    besExport.println(monstre[moAE].jambe[i2].y);
    besExport.println(monstre[moAE].jambe[i2].att);
    besExport.println(monstre[moAE].jambe[i2].lJ);
  }
  for (int i2=0;i2<monstre[moAE].nbBecs;i2++) {
    besExport.println(monstre[moAE].bec[i2].depend);
    besExport.println(monstre[moAE].bec[i2].x);
    besExport.println(monstre[moAE].bec[i2].y);
    besExport.println(monstre[moAE].bec[i2].att);      
    besExport.println(monstre[moAE].bec[i2].a);
    besExport.println(monstre[moAE].bec[i2].l);      
  }
  for (int i2=0;i2<monstre[moAE].nbYeux;i2++) {
    besExport.println(monstre[moAE].oeil[i2].depend);
    besExport.println(monstre[moAE].oeil[i2].x);
    besExport.println(monstre[moAE].oeil[i2].y);
    besExport.println(monstre[moAE].oeil[i2].att);
    besExport.println(monstre[moAE].oeil[i2].r);
  }
  besExport.flush(); // Writes the remaining data to the file
  besExport.close(); // Finishes the file
  monstre[moAE]=new MonstresMorts(moAE);
}

byte[] fInput;

public void dropEvent(DropEvent theDropEvent) {
  if (waitForDrop==true) {
    waitForDrop=false;
    phase=1;
    if (theDropEvent.filePath().substring(theDropEvent.filePath().length()-4,theDropEvent.filePath().length())!=".mon") {
      String nom="";
      for (int i=theDropEvent.filePath().length()-1;i>0;i--) {
        if (theDropEvent.filePath().charAt(i)==92) {
          nom=theDropEvent.filePath().substring(i+1,theDropEvent.filePath().length());
          i=0;
        }
      }
      fInput = loadBytes(theDropEvent.filePath());
      EditF(nom);
    } 
    else{
      besInput=loadStrings(theDropEvent.file());
      int bIIn=0;//besInput index    
      monstre[moAE]=new MonstresA(moAE);
      monstre[moAE].nom=besInput[bIIn];
      monstre[moAE].type=PApplet.parseInt(besInput[bIIn+1]);
      monstre[moAE].nbCorps=PApplet.parseInt(besInput[bIIn+2]);
      monstre[moAE].nbJambes=PApplet.parseInt(besInput[bIIn+3]);
      monstre[moAE].nbYeux=PApplet.parseInt(besInput[bIIn+4]);
      monstre[moAE].nbBecs=PApplet.parseInt(besInput[bIIn+5]);
      monstre[moAE].taille=PApplet.parseFloat(besInput[bIIn+6]);
      monstre[moAE].espVie=PApplet.parseFloat(besInput[bIIn+7]);
      //pas d'import de nb
      monstre[moAE].tmpDecision=PApplet.parseInt(besInput[bIIn+9]);
      bIIn+=10;
      for (int i2=0;i2<monstre[moAE].nbCorps;i2++) {
        monstre[moAE].corps[i2]=new Corps(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]),PApplet.parseFloat(besInput[bIIn+4]));
        bIIn+=5;
      }
      for (int i2=0;i2<monstre[moAE].nbJambes;i2++) {
        monstre[moAE].jambe[i2]=new Jambes(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]));
        monstre[moAE].jambe[i2].y=PApplet.parseFloat(besInput[bIIn+2]);
        monstre[moAE].jambe[i2].lJ=PApplet.parseFloat(besInput[bIIn+4]);
        bIIn+=5;
      }
      for (int i2=0;i2<monstre[moAE].nbBecs;i2++) {
        monstre[moAE].bec[i2]=new Becs(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]));      
        monstre[moAE].bec[i2].a=PApplet.parseFloat(besInput[bIIn+4]);
        monstre[moAE].bec[i2].l=PApplet.parseFloat(besInput[bIIn+5]);
        bIIn+=6;
      }
      for (int i2=0;i2<monstre[moAE].nbYeux;i2++) {
        monstre[moAE].oeil[i2]=new Yeux(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]),PApplet.parseFloat(besInput[bIIn+4]));
        bIIn+=5;
      }
      //puis d\u00e9truit le fichier
      PrintWriter toDelete;
      toDelete = createWriter(theDropEvent.file());
      toDelete.flush(); // Writes the remaining data to the file
      toDelete.close(); // Finishes the file
    }
  }
  else {
    if (theDropEvent.filePath().substring(theDropEvent.filePath().length()-4,theDropEvent.filePath().length())!=".pays") {
      String[] payInput;
      payInput=loadStrings(theDropEvent.filePath());
      int bIIn=0;
      pays[paysC].nom=(String)payInput[bIIn++];
      pays[paysC].teinte=PApplet.parseFloat(payInput[bIIn++]);
      pays[paysC].beats=PApplet.parseInt(payInput[bIIn++]);
      pays[paysC]=new Pays(pays[paysC].beats);
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].noiseV[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].noiseD[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].noiseF[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].noiseA[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].sinV[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].sinD[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].sinF[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      for (int i=0;i<pays[paysC].beats;i++) {
        pays[paysC].sinA[i]=PApplet.parseFloat(payInput[bIIn++]);
      }
      pays[paysC].tempo=PApplet.parseFloat(payInput[bIIn++]);  
      for (int i=0;i<nbNotes;i++) {
        pays[paysC].freq[i]=PApplet.parseFloat(payInput[bIIn++]);
      }      
    }    
  }
}

public float[] val(int n,float mini,float maxi) {
  float[] val=new float[n];
  int seque=floor(fInput.length/n);
  for (int i=0;i<n;i++) {
    for (int i2=0;i2<seque;i2++) {
      val[i]+=fInput[i2+(i*seque)]+128;
    }
    val[i]=map(val[i]%256,0,256,mini,maxi);
  }
  return val;
}

public int[] valI(int n,float mini,float maxi) {
  int[] valI=new int[n];
  for (int i=0;i<n;i++) {
    valI[i]=floor(val(n,mini,maxi+1)[i]);
  }
  return valI;
}

public void EditF(String nom) {
  int r=valI(1,1,3)[0];
  if (r==0) {
    monstre[moAE]=new MonstresA(moAE);
  }
  if (r==1) {
    monstre[moAE]=new MonstresB(moAE);
  }
  if (r==2) {
    monstre[moAE]=new MonstresC(moAE);
  }    

  monstre[moAE].nom=nom;
  monstre[moAE].sS=true;
  //Rajouter l'esperance de vie !

  int[] nbMembresFF=valI(4,0,10);

  //propri\u00e9t\u00e9s monstre A
  float tmpV=50;
  float[] tmpVFF = val(nbBourses,-5,5);
  for (int i=0;i<nbBourses;i++) {
    tmpV=constrain(tmpV+tmpVFF[i],10,150);
    monstre[moAE].bourseL[i] = tmpV;
  }
  for (int i=0;i<nbBourses;i++) {
    tmpV=(float)(i*TWO_PI/nbBourses);
    monstre[moAE].bourseR[i] = tmpV;
  }
  monstre[moAE].nbCils=nbMembresFF[0];
  monstre[moAE].nbTentacules=nbMembresFF[1];
  monstre[moAE].nbBras=nbMembresFF[2];
  monstre[moAE].nbYeuxA=nbMembresFF[3];
  int[] baFF=valI(4,0,nbBourses-1);
  float[] diFF=val(4,0,150);
  float[] anFF=val(4,-HALF_PI,HALF_PI);  
  for (int i=0;i<monstre[moAE].nbCils;i++) {
    monstre[moAE].cil[i]= new Cils(moAE, baFF[0], diFF[0], anFF[0]);
  }
  for (int i=0;i<monstre[moAE].nbTentacules;i++) {
    monstre[moAE].tentacule[i]= new Tentacules(moAE, baFF[1], diFF[1], anFF[1]);
  }
  for (int i=0;i<monstre[moAE].nbBras;i++) {
    monstre[moAE].bras[i]= new Bras(moAE, baFF[2], diFF[2], anFF[2]);
  }
  for (int i=0;i<monstre[moAE].nbYeuxA;i++) {
    monstre[moAE].oeilA[i]= new YeuxA(moAE, baFF[3], diFF[3], anFF[3]);
  }

  //propri\u00e9t\u00e9s monstre B
  monstre[moAE].nbCorps=max(nbMembresFF[0],1);
  monstre[moAE].nbJambes=nbMembresFF[1];
  monstre[moAE].nbYeux=nbMembresFF[2];
  monstre[moAE].nbBecs=nbMembresFF[3];
  float[] raFF=val(3,5,50);
  float[] pxyFF=val(8,-50,50);
  for (int i=0;i<monstre[moAE].nbCorps;i++) {
    if (i==0) {
      monstre[moAE].corps[i]=new Corps(moAE, 0, 0, 0, raFF[0]);
    }
    else{
      monstre[moAE].corps[i]=new Corps(moAE, floor(random(i)), pxyFF[0], pxyFF[1], raFF[1]);      
    }
    monstre[moAE].corps[i].setAttache();
    monstre[moAE].corps[i].xR=monstre[moAE].corps[i].attX+monstre[moAE].corps[i].x;
    monstre[moAE].corps[i].yR=monstre[moAE].corps[i].attY+monstre[moAE].corps[i].y;
  }
  int[] atFF=valI(3,0,monstre[moAE].nbCorps-1);
  for (int i=0;i<monstre[moAE].nbJambes;i++) { 
    int att=floor(atFF[0]);
    float x=constrain(pxyFF[2],-150-monstre[moAE].corps[att].xR,150-monstre[moAE].corps[att].xR);
    float y=constrain(pxyFF[3],-150-monstre[moAE].corps[att].yR,150-monstre[moAE].corps[att].yR);
    monstre[moAE].jambe[i]=new Jambes(moAE, att,x,y);
  }
  for (int i=0;i<monstre[moAE].nbBecs;i++) {
    int att=floor(atFF[1]);
    float x=constrain(pxyFF[4],-150-monstre[moAE].corps[att].xR,150-monstre[moAE].corps[att].xR);
    float y=constrain(pxyFF[5],-150-monstre[moAE].corps[att].yR,150-monstre[moAE].corps[att].yR);
    monstre[moAE].bec[i]=new Becs(moAE, att,x,y);
  }
  for (int i=0;i<monstre[moAE].nbYeux;i++) {
    int att=floor(atFF[2]);
    float x=constrain(pxyFF[6],-150-monstre[moAE].corps[att].xR,150-monstre[moAE].corps[att].xR);
    float y=constrain(pxyFF[7],-150-monstre[moAE].corps[att].yR,150-monstre[moAE].corps[att].yR);
    monstre[moAE].oeil[i]=new Yeux(moAE, att,x,y,raFF[2]);
  }

  //propri\u00e9t\u00e9s monstre C
  float[] tvFF=val(nbVertebres,0,100);
  for (int i=0;i<nbVertebres;i++) {
    monstre[moAE].gVert[i]=tvFF[i];
  }
  monstre[moAE].nbPics=nbMembresFF[0];
  monstre[moAE].nbQueues=nbMembresFF[1];
  monstre[moAE].nbAiles=nbMembresFF[2];
  monstre[moAE].nbYeuxC=nbMembresFF[3];
  int[] vaFF=valI(4,0,nbVertebres-2);
  for (int i=0;i<monstre[moAE].nbPics;i++) {
    int att=vaFF[0];
    monstre[moAE].pic[i]= new Pics(moAE, att,random(150-monstre[moAE].gVert[att]), random(TWO_PI));
  }
  for (int i=0;i<monstre[moAE].nbQueues;i++) {
    int att=vaFF[1];
    monstre[moAE].queue[i]= new Queues(moAE, att, random(150-monstre[moAE].gVert[att]), random(TWO_PI));
  }
  for (int i=0;i<monstre[moAE].nbAiles;i++) {
    int att=vaFF[2];
    monstre[moAE].aile[i]= new Ailes(moAE, att, random(150-monstre[moAE].gVert[att]), random(TWO_PI));
  }
  for (int i=0;i<monstre[moAE].nbYeuxC;i++) {
    int att=vaFF[3];
    monstre[moAE].oeilC[i]= new YeuxC(moAE, att, random(150-monstre[moAE].gVert[att]), random(TWO_PI));
  }

  monstre[moAE].pasRemue();
  placeAuto();

}


PrintWriter besOutput;

public void saveTheFile() {
  besOutput = createWriter("/data/bestiaire.txt");
  besOutput.println(nbMonstres);
  for (int i=0;i<nbMonstres;i++) {
    besOutput.println(monstre[i].nom);
    besOutput.println(monstre[i].type);
    besOutput.println(monstre[i].taille);
    besOutput.println(monstre[i].espVie);
    besOutput.println(monstre[i].nb);
    besOutput.println(monstre[i].tmpDecision);
    besOutput.println(monstre[i].sS);    
    if (monstre[i].type==1) {
      for (int i2=0;i2<nbBourses;i2++) {
        besOutput.println(monstre[i].bourseL[i2]);
      }
      for (int i2=0;i2<nbBourses;i2++) {
        besOutput.println(monstre[i].bourseR[i2]);
      }
      besOutput.println(monstre[i].nbCils);
      besOutput.println(monstre[i].nbTentacules);
      besOutput.println(monstre[i].nbBras);
      besOutput.println(monstre[i].nbYeuxA);
      for (int i2=0;i2<monstre[i].nbCils;i2++) {
        besOutput.println(monstre[i].cil[i2].depend);
        besOutput.println(monstre[i].cil[i2].att);
        besOutput.println(monstre[i].cil[i2].l);      
        besOutput.println(monstre[i].cil[i2].corr);
      }
      for (int i2=0;i2<monstre[i].nbTentacules;i2++) {
        besOutput.println(monstre[i].tentacule[i2].depend);
        besOutput.println(monstre[i].tentacule[i2].att);
        besOutput.println(monstre[i].tentacule[i2].l);
        besOutput.println(monstre[i].tentacule[i2].corr);
      }
      for (int i2=0;i2<monstre[i].nbBras;i2++) {
        besOutput.println(monstre[i].bras[i2].depend);
        besOutput.println(monstre[i].bras[i2].att);
        besOutput.println(monstre[i].bras[i2].l);
        besOutput.println(monstre[i].bras[i2].corr);
      }
      for (int i2=0;i2<monstre[i].nbYeuxA;i2++) {
        besOutput.println(monstre[i].oeilA[i2].depend);
        besOutput.println(monstre[i].oeilA[i2].att);
        besOutput.println(monstre[i].oeilA[i2].l);
        besOutput.println(monstre[i].oeilA[i2].corr);
      }
    }
    if (monstre[i].type==2) {
      besOutput.println(monstre[i].nbCorps);
      besOutput.println(monstre[i].nbJambes);
      besOutput.println(monstre[i].nbYeux);
      besOutput.println(monstre[i].nbBecs);
      for (int i2=0;i2<monstre[i].nbCorps;i2++) {
        besOutput.println(monstre[i].corps[i2].depend);
        besOutput.println(monstre[i].corps[i2].x);
        besOutput.println(monstre[i].corps[i2].y);
        besOutput.println(monstre[i].corps[i2].att);    
        besOutput.println(monstre[i].corps[i2].r);    
      }
      for (int i2=0;i2<monstre[i].nbJambes;i2++) {      
        besOutput.println(monstre[i].jambe[i2].depend);
        besOutput.println(monstre[i].jambe[i2].x);
        besOutput.println(monstre[i].jambe[i2].y);
        besOutput.println(monstre[i].jambe[i2].att);
        besOutput.println(monstre[i].jambe[i2].lJ);
      }
      for (int i2=0;i2<monstre[i].nbBecs;i2++) {
        besOutput.println(monstre[i].bec[i2].depend);
        besOutput.println(monstre[i].bec[i2].x);
        besOutput.println(monstre[i].bec[i2].y);
        besOutput.println(monstre[i].bec[i2].att);      
        besOutput.println(monstre[i].bec[i2].a);
        besOutput.println(monstre[i].bec[i2].l);      
      }
      for (int i2=0;i2<monstre[i].nbYeux;i2++) {
        besOutput.println(monstre[i].oeil[i2].depend);
        besOutput.println(monstre[i].oeil[i2].x);
        besOutput.println(monstre[i].oeil[i2].y);
        besOutput.println(monstre[i].oeil[i2].att);
        besOutput.println(monstre[i].oeil[i2].r);
      }
    }
    if (monstre[i].type==3) {
      for (int i2=0;i2<nbVertebres;i2++) {
        besOutput.println(monstre[i].gVert[i2]);
      }
      besOutput.println(monstre[i].nbPics);
      besOutput.println(monstre[i].nbQueues);
      besOutput.println(monstre[i].nbAiles);
      besOutput.println(monstre[i].nbYeuxC);
      for (int i2=0;i2<monstre[i].nbPics;i2++) {
        besOutput.println(monstre[i].pic[i2].depend);
        besOutput.println(monstre[i].pic[i2].att);
        besOutput.println(monstre[i].pic[i2].l);
        besOutput.println(monstre[i].pic[i2].corr);
      }
      for (int i2=0;i2<monstre[i].nbQueues;i2++) {
        besOutput.println(monstre[i].queue[i2].depend);
        besOutput.println(monstre[i].queue[i2].att);
        besOutput.println(monstre[i].queue[i2].l);
        besOutput.println(monstre[i].queue[i2].corr);
      }
      for (int i2=0;i2<monstre[i].nbAiles;i2++) {
        besOutput.println(monstre[i].aile[i2].depend);
        besOutput.println(monstre[i].aile[i2].att);
        besOutput.println(monstre[i].aile[i2].l);
        besOutput.println(monstre[i].aile[i2].corr);
      }
      for (int i2=0;i2<monstre[i].nbYeuxC;i2++) {
        besOutput.println(monstre[i].oeilC[i2].depend);
        besOutput.println(monstre[i].oeilC[i2].att);
        besOutput.println(monstre[i].oeilC[i2].l);
        besOutput.println(monstre[i].oeilC[i2].corr);
      }
    }
  }
  besOutput.flush(); // Writes the remaining data to the file
  besOutput.close(); // Finishes the file
}

String[] besInput;

public void loadTheFile() {
  besInput=loadStrings("/data/bestiaire.txt");
  if (besInput.length>0) {
    int bIIn=0;//besInput index
    nbMonstres=PApplet.parseInt(besInput[bIIn++]);
    for (int i=0;i<nbMonstres;i++) {
      if (PApplet.parseInt(besInput[bIIn+1])==0) {
        monstre[i]=new MonstresMorts(i);
      }
      if (PApplet.parseInt(besInput[bIIn+1])==1) {
        monstre[i]=new MonstresA(i);
      }
      if (PApplet.parseInt(besInput[bIIn+1])==2) {
        monstre[i]=new MonstresB(i);
      }
      if (PApplet.parseInt(besInput[bIIn+1])==3) {
        monstre[i]=new MonstresC(i);
      }
      monstre[i].nom=besInput[bIIn++];
      monstre[i].type=PApplet.parseInt(besInput[bIIn++]);
      monstre[i].taille=PApplet.parseFloat(besInput[bIIn++]);
      monstre[i].espVie=PApplet.parseFloat(besInput[bIIn++]);
      monstre[i].nb=PApplet.parseInt(besInput[bIIn++]);
      monstre[i].tmpDecision=PApplet.parseInt(besInput[bIIn++]);
      monstre[i].sS=PApplet.parseBoolean(besInput[bIIn++]);
      if (monstre[i].type==1) {
        for (int i2=0;i2<nbBourses;i2++) {
          monstre[i].bourseL[i2]=PApplet.parseFloat(besInput[bIIn++]);
        }
        for (int i2=0;i2<nbBourses;i2++) {
          monstre[i].bourseR[i2]=PApplet.parseFloat(besInput[bIIn++]);
        }
        monstre[i].nbCils=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbTentacules=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbBras=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbYeuxA=PApplet.parseInt(besInput[bIIn++]);
        for (int i2=0;i2<monstre[i].nbCils;i2++) {
          monstre[i].cil[i2]=new Cils(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));
        }
        for (int i2=0;i2<monstre[i].nbTentacules;i2++) {
          monstre[i].tentacule[i2]=new Tentacules(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));
        }
        for (int i2=0;i2<monstre[i].nbBras;i2++) {
          monstre[i].bras[i2]=new Bras(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));
        }
        for (int i2=0;i2<monstre[i].nbYeuxA;i2++) {
          monstre[i].oeilA[i2]=new YeuxA(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));
        }
      }
      if (monstre[i].type==2) {
        monstre[i].nbCorps=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbJambes=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbYeux=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbBecs=PApplet.parseInt(besInput[bIIn++]);
        for (int i2=0;i2<monstre[i].nbCorps;i2++) {
          monstre[i].corps[i2]=new Corps(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]),PApplet.parseFloat(besInput[bIIn+4]));
          bIIn+=5;
        }
        for (int i2=0;i2<monstre[i].nbJambes;i2++) {
          monstre[i].jambe[i2]=new Jambes(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]));
          monstre[i].jambe[i2].y=PApplet.parseFloat(besInput[bIIn+2]);
          monstre[i].jambe[i2].lJ=PApplet.parseFloat(besInput[bIIn+4]);
          bIIn+=5;
        }
        for (int i2=0;i2<monstre[i].nbBecs;i2++) {
          monstre[i].bec[i2]=new Becs(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]));      
          monstre[i].bec[i2].a=PApplet.parseFloat(besInput[bIIn+4]);
          monstre[i].bec[i2].l=PApplet.parseFloat(besInput[bIIn+5]);
          bIIn+=6;
        }
        for (int i2=0;i2<monstre[i].nbYeux;i2++) {
          monstre[i].oeil[i2]=new Yeux(PApplet.parseInt(besInput[bIIn]),PApplet.parseInt(besInput[bIIn+3]),PApplet.parseFloat(besInput[bIIn+1]),PApplet.parseFloat(besInput[bIIn+2]),PApplet.parseFloat(besInput[bIIn+4]));
          bIIn+=5;
        }
      }
      if (monstre[i].type==3) {
        for (int i2=0;i2<nbVertebres;i2++) {
          monstre[i].gVert[i2]=PApplet.parseInt(besInput[bIIn++]);
        }
        monstre[i].nbPics=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbQueues=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbAiles=PApplet.parseInt(besInput[bIIn++]);
        monstre[i].nbYeuxC=PApplet.parseInt(besInput[bIIn++]);
        for (int i2=0;i2<monstre[i].nbPics;i2++) {
          monstre[i].pic[i2]=new Pics(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));        
        }
        for (int i2=0;i2<monstre[i].nbQueues;i2++) {
          monstre[i].queue[i2]=new Queues(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));        
        }
        for (int i2=0;i2<monstre[i].nbAiles;i2++) {
          monstre[i].aile[i2]=new Ailes(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));        
        }
        for (int i2=0;i2<monstre[i].nbYeuxC;i2++) {
          monstre[i].oeilC[i2]=new YeuxC(PApplet.parseInt(besInput[bIIn++]),PApplet.parseInt(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]),PApplet.parseFloat(besInput[bIIn++]));        
        }
      }
    }
  }
  else{
    reset();
  }
}
boolean syncKeys=false;

public void tic(int tic) {
  if (tic==1) {
    tempoWaiter=0;
  }
}

public void midiS(int tic) {
  if (nbMonSS>0) {
    envoieSon(mSSN[tic%nbMonSS]);
  }
}

public void syncKcompute() {
  if (nbMonSS>0) {
    envoieSon(mSSN[keyCode%nbMonSS]);
  }
}

public void sonPP5(String nom, float teinte, int beats, float[] noiseV, float[] noiseD, float[] noiseF, float[] noiseA, float[] sinV, float[] sinD, float[] sinF, float[] sinA, float tempo, float[] freq) {
  pays[paysC].nom=nom;
  pays[paysC].teinte=teinte;
  pays[paysC].beats=beats;
  for (int i=0;i<pays[paysC].beats;i++) {  
    pays[paysC].noiseV[i]=noiseV[i];
    pays[paysC].noiseD[i]=noiseD[i];
    pays[paysC].noiseF[i]=noiseF[i];
    pays[paysC].noiseA[i]=noiseA[i];
    pays[paysC].sinV[i]=sinV[i];
    pays[paysC].sinD[i]=sinD[i];
    pays[paysC].sinF[i]=sinF[i];
    pays[paysC].sinA[i]=sinA[i];
  }
  pays[paysC].tempo=tempo;
  for (int i=0;i<nbNotes;i++) {
    pays[paysC].freq[i]=freq[i];
  }
}

int lar=sizx;//taille de la fen\u00eatre
int scroll=50;
float[] sol= new float[lar+scroll];//position du sol
float ang;
float lunex;
float luney;
float dlunex=alea(0,1);
float dluney=alea(0,1);
float luner=random(-10,10)+80;
float variesol;
int grode;
int vitransfo=3;//lenteur de la fusion
int couleurpersos;//couleur des silhouettes
float ravb=random(3,7);
float gavb=random(5,9);
float bavb=random(1,5);
PrintWriter output;
String[] input;
int nbEtIn=floor(random(100))*floor(random(3));
float[] etInX= new float[nbEtIn];
float[] etInY= new float[nbEtIn];
float[] etInR= new float[nbEtIn];

int nbb=5;//nombre de baites
Baites[] baite = new Baites[nbb];
int nb=0;
int nbt=0;

//Boutons pABestiaire = new Boutons("Aller au bestiaire",sizx/3,sizy/5,sizx/3,sizy/5,10,0,100,150,100,150);

public void sourisPhaseA() {
  allerAuBestiaire(); 
}

public void setupIntro() {
  noStroke();
  couleurpersos=0;
  grode=0;
  sol[0]=height*3/4;
  variesol=0;
  for (int i=1;i<width;i++) {
    variesol=constrain(variesol+random(-1,1),-1,1);
    sol[i]=constrain(sol[i-1]+variesol,height/2,height);
  }
  lunex=random(width);
  luney=random(height);
  for (int i=0;i<nbEtIn;i++) {
    etInX[i]=random(sizx);
    etInY[i]=random(sizy);
    etInR[i]=random(3);
  }
}

class Baites {
  float x;//position globale en x
  float y;//position globale en y  
  float jl;//longueur des membres jambes
  float jg;//grosseur des jambes
  float cr;//rayon du corps
  float bl;//longueur du bec
  float ao=0;//angle d'ouverture
  float d;//it\u00e9ration continue pour l'agissement
  float[] ppx = new float[2];//position du pied en x
  float[] ppy = new float[2];//position du pied en y
  float[] pgx = new float[2];//position du genou en x
  float[] pgy = new float[2];//position du genou en y
  float ob;//ouverture du bec
  float vc;//vitesse de course
  float ht;//hauteur de la t\u00eate
  float tr;//hauteur de la t\u00eate
  int nb;//quelle occurence
  int np;//nombre de plumes
  float pr;//rayon des plumes
  float nl;//nombre de lames
  float lt;//taille des lames

  Baites(int nb,float x,float y,float jl,float jg,float cr,float bl,float ob,float vc,float ht,float tr, int np, float pr,int nl,float lt) {
    this.x=x;
    this.y=y;
    this.jl=jl;
    this.jg=jg;
    this.cr=cr;
    this.bl=bl;
    this.ob=ob;
    this.vc=vc;
    this.ht=ht;
    this.tr=tr;
    this.nb=nb;
    this.np=np;
    this.pr=pr;
    this.nl=nl;
    this.lt=lt;
  }

  public void dessin() {
    noStroke();
    fill(constrain(couleurpersos,0,255),constrain(couleurpersos/2,0,255),constrain(couleurpersos/3,0,255));
    ellipse(x,y,cr*2,cr*2);//le corps
    quad(x-tr,y-ht,x+tr,y-ht,x+cr,y,x-cr,y);//la jointure du corps et de la t\u00eate
    ellipse(x,y-ht,tr*2,tr*2);//la t\u00eate
    triangle(x+bl*(cos(ao*PI/180)),y+bl*(sin(ao*PI/180))-ht,x,y+tr-ht,x+tr,y-ht);//le bec du haut
    triangle(x+bl*(cos(-ao*PI/180)),y+bl*(sin(-ao*PI/180))-ht,x,y-tr-ht,x+tr,y-ht);//le bec du bas 
    ellipse(x+ppx[0], y+ppy[0],jg,jg);//le pied
    ellipse(x+ppx[1], y+ppy[1],jg,jg);//l'autre pied
    for (int i=0;i<2;i++) {
      float[] pjx=new float[7]; 
      float[] pjy=new float[7];
      pjx[0]=x+cr*cos(angle(pgx[i],pgy[i])+PI/2);
      pjy[0]=y+cr*sin(angle(pgx[i],pgy[i])+PI/2);
      pjx[1]=x+cr*cos(angle(pgx[i],pgy[i])+PI*3/2);
      pjy[1]=y+cr*sin(angle(pgx[i],pgy[i])+PI*3/2);
      pjx[2]=x+pgx[i]+(jg+cr)/2*cos(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI/2);
      pjy[2]=y+pgy[i]+(jg+cr)/2*sin(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI/2);
      pjx[3]=x+pgx[i]+(jg+cr)/2*cos(angle(pgx[i],pgy[i])+PI*3/2);
      pjy[3]=y+pgy[i]+(jg+cr)/2*sin(angle(pgx[i],pgy[i])+PI*3/2);
      pjx[4]=x+pgx[i]+(jg+cr)/2*cos(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI*3/2);
      pjy[4]=y+pgy[i]+(jg+cr)/2*sin(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI*3/2);
      pjx[5]=x+ppx[i]+jg/2*cos(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI/2);
      pjy[5]=y+ppy[i]+jg/2*sin(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI/2);
      pjx[6]=x+ppx[i]+jg/2*cos(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI*3/2);
      pjy[6]=y+ppy[i]+jg/2*sin(angle(ppx[i]-pgx[i],ppy[i]-pgy[i])+PI*3/2);
      beginShape();
      vertex(pjx[0],pjy[0]);
      vertex(pjx[1],pjy[1]);      
      vertex(pjx[3],pjy[3]);      
      vertex(pjx[4],pjy[4]);
      vertex(pjx[6],pjy[6]);
      vertex(pjx[5],pjy[5]);
      vertex(pjx[2],pjy[2]);      
      vertex(pjx[0],pjy[0]);            
      endShape();      
    }
    for (int i=0;i<np;i++) { // dessine les plumes
      ellipse(x-(tr+pr)*cos((PI/2)/np*i),y-ht-(tr+pr)*sin((PI/2)/np*i),pr*2,pr*2);
    }
    for (int i=0;i<nl;i++) { // dessine les lames
      triangle(x-lt,y-ht/nl*(i+1)/2,x,y-ht/nl*i,x,y-ht/nl*(i+1));
    }
    fill(200);
    ellipse(x+tr/3,y-tr/3-ht,constrain(tr/5,2,tr),constrain(tr/5,2,tr));//l'oeil
  }

  public void agit() {
    d+=0.1f;
    ao=sin(d)*ob+ob;//ouverture du bec
    float dppx=0;
    for (int i=0;i<2;i++) {
      float appx=ppx[i];
      ppx[i]=cos(d*vc+i*PI)*jl;
      dppx=max(dppx,abs(ppx[i]-appx));
      ppy[i]=(1.5f*jl)+sin(d*vc+i*PI)*jl;
    }
    x+=dppx;//avance
    if (x>width+cr) {
      x=-100;
      creebaite2(nb);
    }

    //si pied en dessous du sol alors remonte, et inversement
    float psol=(y+ppy[0])-sol[floor(constrain((x+ppx[0]),0,width-1))];
    float psol2=(y+ppy[1])-sol[floor(constrain((x+ppx[1]),0,width-1))];
    y-=max(psol,psol2);    

    for (int i=0;i<2;i++) {
      pgy[i]=ppy[i]-jl;
      for (float i2=0;i2<=jl;i2++) {
        if (abs(longueur(i2,pgy[i],ppx[i],ppy[i])-jl)<abs(longueur(pgx[i],pgy[i],ppx[i],ppy[i])-jl) && i2>ppx[i]) {
          pgx[i]=i2;
        }
      }
    }
  }

}

public void phaseA() {
  effaceecran();
  noStroke();
  affichelune();
  tracelesol();

  if (grode>1) {//fuuuusion !
    for (int i=0;i<nbt;i++) {
      baite[i].x+=((width/2)-baite[i].x)/vitransfo;
      baite[i].y+=((height/2)-baite[i].y)/vitransfo;

      int i2=i+1;
      if (i2==nbt) {
        i2=0;
      }

      baite[i].jl=(baite[i].jl+baite[i2].jl)/2;
      baite[i].jg=(baite[i].jg+baite[i2].jg)/2;
      baite[i].cr=(baite[i].cr+baite[i2].cr)/2;
      baite[i].tr=(baite[i].tr+baite[i2].tr)/2;
      baite[i].bl=(baite[i].bl+baite[i2].bl)/2;
      baite[i].ob=(baite[i].ob+baite[i2].ob)/2;
      baite[i].vc=(baite[i].vc+baite[i2].vc)/2;
      baite[i].ht=(baite[i].ht+baite[i2].ht)/2;
      baite[i].pr=(baite[i].pr+baite[i2].pr)/2;
      baite[i].lt=(baite[i].lt+baite[i2].lt)/2;
    }
    couleurpersos+=20;
    grode-=1;
  }

  if (grode==1) {//fusion pour de vrai cette fois
    float tmpjl,tmpjg,tmpcr,tmptr,tmpbl,tmpob,tmpvc,tmpht,tmppr,tmplt;
    int tmpnp,tmpnl;
    tmpjl=tmpjg=tmpcr=tmptr=tmpbl=tmpob=tmpvc=tmpht=tmppr=tmplt=0;
    tmpnp=tmpnl=0;
    for (int i=0;i<nbt;i++) {
      tmpjl+=baite[i].jl/nbt;
      tmpjg+=baite[i].jg/nbt;
      tmpcr+=baite[i].cr/nbt;
      tmptr+=baite[i].tr/nbt;
      tmpbl+=baite[i].bl/nbt;
      tmpob+=baite[i].ob/nbt;
      tmpvc+=baite[i].vc/nbt;
      tmpht+=baite[i].ht/nbt;
      tmppr+=baite[i].pr/nbt;
      tmplt+=baite[i].lt/nbt;
      tmpnp+=baite[i].np;
      tmpnl+=baite[i].nl;
    }
    if (nbt>0) {
      tmpnp=floor(tmpnp/nbt);
      tmpnl=floor(tmpnl/nbt);
    }
    for (int i=0;i<nbt;i++) {
      if (i==0) {
        Baites truc = new Baites(i,width/2,0,tmpjl,tmpjg,tmpcr,tmpbl,tmpob,tmpvc,tmpht,tmptr,tmpnp,tmppr,tmpnl,tmplt);
        baite[i]=truc;
      }
      if (i!=0) {
        creebaite2(i);
      }
    }
    nb=1;
    nbt=1;
    couleurpersos=0;
    grode=0;

  }

  for (int i=0;i<nbt;i++) {
    baite[i].agit();
    baite[i].dessin();
  }

  if (nbt<nbb) {
    if (random(100)<2) { // 2% chances de cr\u00e9er une b\u00eate
      creebaite();
    }
  }

  //  pABestiaire.dessine();
  noStroke();
  fill(200);
  textFont(font[3], (width+height)/20);
  textAlign(CENTER,CENTER);
  String titre="";
  if (langue==0) {
    titre="B\u00eates noires";
  }
  if (langue==1) {
    titre="B\u00eates noires";
  }  
  text(titre, width/2, height/3);      

}

public float longueur(float x,float y,float x2,float y2) {
  return(sqrt(sq(x2-x)+sq(y2-y)));
}

public void creebaite() {
  creebaite2(nb);
  nb++;
  nbt++;
  nbt=constrain(nbt,0,nbb);
  if (nb==nbb) {
    nb=0;
  }
}

public void creebaite2(int nb) {
  float tmpjl=random(10,60);
  float tmpjg=alea(1,20);
  float tmpcr=alea(5,50);
  float tmptr=alea(5,30);
  float tmpbl=random(tmptr+5,tmptr+30);
  float tmpob=random(5,22);
  float tmpvc=random(0.1f,2);
  float tmpht=random(0,50);
  int tmpnp=floor(alea(1,10));
  float tmppr=alea(2,10);
  int tmpnl=floor(random(1,5));
  float tmplt=random(10,20);
  Baites truc = new Baites(nb,-50,0,tmpjl,tmpjg,tmpcr,tmpbl,tmpob,tmpvc,tmpht,tmptr,tmpnp,tmppr,tmpnl,tmplt);
  baite[nb]=truc;
}

public float angle(float vx,float vy) {
  if (vx>0) {
    if (vy>0) {
      ang=atan(vy/vx);
    }
    if (vy<0) {
      ang=atan(vy/vx)+2*PI;
    }
  }
  if (vx<0) {
    ang=atan(vy/vx)+PI;
  }
  if (vx==0) {
    if (vy>0){
      ang=PI/2;
    }
    if (vy<0){
      ang=3/2*PI;
    }
  }
  return ang;
}

public float alea(float de,float et) {
  return random(random(et-de))+de;
}

public void effaceecran() {
  for (int i=0;i<height;i++) {
    stroke(ravb,i/gavb+10,i/bavb+10);//4,6,2
    line(0,i,width,i);//efface l'\u00e9cran
  }
  ravb+=random(-0.01f,0.01f);
  gavb+=random(-0.01f,0.01f);
  bavb+=random(-0.01f,0.01f);
}

public void tracelesol() {
  for (int i=0;i<width;i++) {
    stroke(50,50,50);
    point(i,sol[i]);//trace le sol
    stroke(0,0,0);
    line(i,sol[i]+1,i,height);//trace en dessous du sol
  }
}

public void affichelune() {
  noStroke();
  fill(16,32,200,200);
  ellipse(lunex,luney,luner*2,luner*2);//dessine la lune
  lunex+=dlunex;
  luney+=dluney;
  if (lunex>width+luner*2) {
    lunex=-luner*2;
  }
  if (luney>height+luner*2) {
    luney=-luner*2;
  }
  for (int i=0;i<nbEtIn;i++) {
    if (longueur(etInX[i],etInY[i],lunex,luney)>luner+etInR[i]) {
      ellipse(etInX[i],etInY[i],etInR[i]*2,etInR[i]*2);//dessine les \u00e9toiles
    }
  }  
}

public void keyPresIntro() {
  if (keyCode == RIGHT) {
    for (int i=0;i<width;i++) {
      sol[i]=sol[i+scroll];
      if(i+scroll>width-1) {
        variesol=constrain(variesol+random(-1,1),-1,1);
        sol[i]=constrain(sol[i-1]+variesol,height/5,height);
      }
    }
    for (int i=0;i<nbEtIn;i++) {
      etInX[i]-=etInR[i]/2;
      if (etInX[i]<-etInR[i]) {
        etInX[i]+=width+etInR[i]*2;
      }
    }
    lunex-=luner/40;
    if (lunex<-luner) {
      lunex+=width+luner*2;
    }
  }
  if (keyCode == ENTER) {
    grode=30;
  }
  if (keyCode == UP) {
    for (int i=0;i<nbt;i++) {
      baite[i].jl+=baite[i].jl/50;
      baite[i].jg+=baite[i].jg/50;
      baite[i].cr+=baite[i].cr/50;
      baite[i].tr+=baite[i].tr/50;
      baite[i].bl+=baite[i].bl/50;
      baite[i].ob+=baite[i].ob/50;
      baite[i].vc-=baite[i].vc/50;
      baite[i].ht+=baite[i].ht/50;
      baite[i].pr+=baite[i].pr/50;
      baite[i].lt+=baite[i].lt/50;
      baite[i].np+=1;
      baite[i].nl+=1;
    }
  }
  if (keyCode == DOWN) {
    for (int i=0;i<nbt;i++) {
      baite[i].jl-=baite[i].jl/50;
      baite[i].jg-=baite[i].jg/50;
      baite[i].cr-=baite[i].cr/50;
      baite[i].tr-=baite[i].tr/50;
      baite[i].bl-=baite[i].bl/50;
      baite[i].ob-=baite[i].ob/50;
      baite[i].vc+=baite[i].vc/50;
      baite[i].ht-=baite[i].ht/50;
      baite[i].pr-=baite[i].pr/50;
      baite[i].lt-=baite[i].lt/50;
      baite[i].np-=1;
      baite[i].nl-=1;
    }
  }
  if (keyCode == LEFT) {
    output = createWriter("data/monstres.txt");
    output.println(nbt+"\t"+nb+"\t"+nbb+"\t"+ravb+"\t"+gavb+"\t"+bavb+"\t"+scroll+"\t"+couleurpersos);
    for (int i=0;i<nbt;i++) {
      output.println(baite[i].x+"\t"+baite[i].y+"\t"+baite[i].jl+"\t"+baite[i].jg+"\t"+baite[i].cr+"\t"+baite[i].bl+"\t"+baite[i].ob+"\t"+baite[i].vc+"\t"+baite[i].ht+"\t"+baite[i].tr+"\t"+baite[i].np+"\t"+baite[i].pr+"\t"+baite[i].nl+"\t"+baite[i].lt+"\t");
    }
    output.flush();
    output.close();
  }
  if (keyCode == CONTROL) {
    input = loadStrings("data/monstres.txt");
    if (input.length>0) {
      String[] parametres2=split(input[0],"\t");
      nbt=PApplet.parseInt(parametres2[0]);
      nb=PApplet.parseInt(parametres2[1]);
      nbb=PApplet.parseInt(parametres2[2]);
      ravb=PApplet.parseFloat(parametres2[3]);
      gavb=PApplet.parseFloat(parametres2[4]);
      bavb=PApplet.parseFloat(parametres2[5]);
      scroll=PApplet.parseInt(parametres2[6]);
      couleurpersos=PApplet.parseInt(parametres2[7]);
      for (int i=0;i<nbt;i++) {
        String[] parametres=split(input[i+1],"\t");
        int tmpx=PApplet.parseInt(parametres[0]);
        int tmpy=PApplet.parseInt(parametres[1]);
        float tmpjl=PApplet.parseFloat(parametres[2]);
        float tmpjg=PApplet.parseFloat(parametres[3]);
        float tmpcr=PApplet.parseFloat(parametres[4]);
        float tmpbl=PApplet.parseFloat(parametres[5]);
        float tmpob=PApplet.parseFloat(parametres[6]);
        float tmpvc=PApplet.parseFloat(parametres[7]);
        float tmpht=PApplet.parseFloat(parametres[8]);
        float tmptr=PApplet.parseFloat(parametres[9]);
        int tmpnp=PApplet.parseInt(parametres[10]);
        float tmppr=PApplet.parseFloat(parametres[11]);
        int tmpnl=PApplet.parseInt(parametres[12]);
        float tmplt=PApplet.parseFloat(parametres[13]);
        Baites truc = new Baites(i,tmpx,tmpy,tmpjl,tmpjg,tmpcr,tmpbl,tmpob,tmpvc,tmpht,tmptr,tmpnp,tmppr,tmpnl,tmplt);
        baite[i]=truc;
      }
    }
  }
}

// attention, ce code source sontient des messages subliminaux ostentatoires.


public void phaseG() {
  image(fondPopUp,0,0);
  fill(0);
  rect (width/3,height/3,width/3,height/3);
  newA.dessine();
  newB.dessine();
  newC.dessine();
  newR.dessine();
}

public void sourisPhaseG() {
  phase=1;
  if (newA.actif()==true) {
    monstre[moAE]=new MonstresA(moAE);
    monstre[moAE].sS=true;
    mAJmSSN();
    placeAuto();    
  }
  else if (newB.actif()==true) {
    monstre[moAE]=new MonstresB(moAE);
    monstre[moAE].sS=true;    
    mAJmSSN();
    placeAuto();    
  }
  else if (newC.actif()==true) {
    monstre[moAE]=new MonstresC(moAE);
    monstre[moAE].sS=true;    
    mAJmSSN();
    placeAuto();    
  }
  else{
    phase=6;//reste dans la m\u00eame phase
  }
}

public void reset() {
  for (int i=0;i<nbMonstres;i++) {
    undoIndex=0;
    Monstres tmpMonstres=new MonstresMorts(i);
    monstre[i]=tmpMonstres;
  }
}

public void EditR() {
  
  int r=floor(random(3));
  if (r==0) {
    monstre[moAE]=new MonstresA(moAE);
  }
  if (r==1) {
    monstre[moAE]=new MonstresB(moAE);
  }
  if (r==2) {
    monstre[moAE]=new MonstresC(moAE);
  }  

  monstre[moAE].nomAleat();
  monstre[moAE].sS=true;

  //propri\u00e9t\u00e9s monstre A
  float tmpV=50;
  for (int i=0;i<nbBourses;i++) {
    tmpV=constrain(tmpV+random(-5,5),10,sizModel/2);
    monstre[moAE].bourseL[i] = tmpV;
  }
  for (int i=0;i<nbBourses;i++) {
    tmpV=(float)(i*TWO_PI/nbBourses);
    monstre[moAE].bourseR[i] = tmpV;
  }
  monstre[moAE].nbCils=floor(random(nbMembresMax));
  monstre[moAE].nbTentacules=floor(random(nbMembresMax));//nombre de tentacules
  monstre[moAE].nbBras=floor(random(nbMembresMax));
  monstre[moAE].nbYeuxA=floor(random(nbMembresMax));
  for (int i=0;i<monstre[moAE].nbCils;i++) {
    monstre[moAE].cil[i]= new Cils(moAE, floor(random(nbBourses)), random(sizModel/2), random(-0.5f,0.5f));
  }
  for (int i=0;i<monstre[moAE].nbTentacules;i++) {
    monstre[moAE].tentacule[i]= new Tentacules(moAE, floor(random(nbBourses)), random(sizModel/2), random(-0.5f,0.5f));
  }
  for (int i=0;i<monstre[moAE].nbBras;i++) {
    monstre[moAE].bras[i]= new Bras(moAE, floor(random(nbBourses)), random(sizModel/2), random(-0.5f,0.5f));
  }
  for (int i=0;i<monstre[moAE].nbYeuxA;i++) {
    monstre[moAE].oeilA[i]= new YeuxA(moAE, floor(random(nbBourses)), random(sizModel/2), random(-0.5f,0.5f));
  }

  //propri\u00e9t\u00e9s monstre B
  monstre[moAE].nbCorps=floor(random(nbMembresMax-1))+1;//nombre de corps
  monstre[moAE].nbJambes=floor(random(nbMembresMax));//nombre de jambes
  monstre[moAE].nbYeux=floor(random(nbMembresMax));//nombre d'yeux
  monstre[moAE].nbBecs=floor(random(nbMembresMax));//nombre de becs
  for (int i=0;i<monstre[moAE].nbCorps;i++) {              
    if (i==0) {
      monstre[moAE].corps[i]=new Corps(moAE, 0, 0, 0, random(5,60));
    }
    else{
      monstre[moAE].corps[i]=new Corps(moAE, floor(random(i)), random(-sizModel/3,sizModel/3), random(-sizModel/3,sizModel/3), random(5,sizModel/3));      
    }
    monstre[moAE].corps[i].setAttache();
    monstre[moAE].corps[i].xR=monstre[moAE].corps[i].attX+monstre[moAE].corps[i].x;
    monstre[moAE].corps[i].yR=monstre[moAE].corps[i].attY+monstre[moAE].corps[i].y;
  }
  for (int i=0;i<monstre[moAE].nbJambes;i++) { 
    int att=floor(random(monstre[moAE].nbCorps));
    float x=constrain(random(-sizModel/3,sizModel/3),-sizModel/2-monstre[moAE].corps[att].xR,sizModel/2-monstre[moAE].corps[att].xR);
    float y=constrain(random(-sizModel/3,sizModel/3),-sizModel/2-monstre[moAE].corps[att].yR,sizModel/2-monstre[moAE].corps[att].yR);
    monstre[moAE].jambe[i]=new Jambes(moAE, att,x,y);
  }
  for (int i=0;i<monstre[moAE].nbBecs;i++) {
    int att=floor(random(monstre[moAE].nbCorps));
    float x=constrain(random(-sizModel/3,sizModel/3),-sizModel/2-monstre[moAE].corps[att].xR,sizModel/2-monstre[moAE].corps[att].xR);
    float y=constrain(random(-sizModel/3,sizModel/3),-sizModel/2-monstre[moAE].corps[att].yR,sizModel/2-monstre[moAE].corps[att].yR);
    monstre[moAE].bec[i]=new Becs(moAE, att,x,y);
  }
  for (int i=0;i<monstre[moAE].nbYeux;i++) {
    int att=floor(random(monstre[moAE].nbCorps));
    float x=constrain(random(-sizModel/3,sizModel/3),-sizModel/2-monstre[moAE].corps[att].xR,sizModel/3-monstre[moAE].corps[att].xR);
    float y=constrain(random(-sizModel/3,sizModel/3),-sizModel/2-monstre[moAE].corps[att].yR,sizModel/3-monstre[moAE].corps[att].yR);
    monstre[moAE].oeil[i]=new Yeux(moAE, att,x,y,random(5,sizModel/4));
  }

  //propri\u00e9t\u00e9s monstre C
  for (int i=0;i<nbVertebres;i++) {
    monstre[moAE].gVert[i]=random(sizModel/3);
  }
  monstre[moAE].nbPics=floor(random(nbMembresMax));
  monstre[moAE].nbQueues=floor(random(nbMembresMax));
  monstre[moAE].nbAiles=floor(random(nbMembresMax));
  monstre[moAE].nbYeuxC=floor(random(nbMembresMax));
  for (int i=0;i<monstre[moAE].nbPics;i++) {
    int att=floor(random(nbVertebres-1));
    monstre[moAE].pic[i]= new Pics(moAE, att,random(sizModel/2-monstre[moAE].gVert[att]), random(-0.5f,0.5f));
  }
  for (int i=0;i<monstre[moAE].nbQueues;i++) {
    int att=floor(random(nbVertebres-1));    
    monstre[moAE].queue[i]= new Queues(moAE, att, random(sizModel/2-monstre[moAE].gVert[att]), random(-0.5f,0.5f));
  }
  for (int i=0;i<monstre[moAE].nbAiles;i++) {
    int att=floor(random(nbVertebres-1));    
    monstre[moAE].aile[i]= new Ailes(moAE, att, random(sizModel/2-monstre[moAE].gVert[att]), random(-0.5f,0.5f));
  }
  for (int i=0;i<monstre[moAE].nbYeuxC;i++) {
    int att=floor(random(nbVertebres-1));    
    monstre[moAE].oeilC[i]= new YeuxC(moAE, att, random(sizModel/2-monstre[moAE].gVert[att]), random(-0.5f,0.5f));
  }

  if (monstre[moAE].type==1) {
    monstre[moAE].espVie+=monstre[moAE].nbCils*300;
    monstre[moAE].espVie+=monstre[moAE].nbTentacules*100;
    monstre[moAE].espVie+=monstre[moAE].nbBras*70;
    monstre[moAE].espVie+=monstre[moAE].nbYeuxA*200;
  }
  if (monstre[moAE].type==2) {
    monstre[moAE].espVie+=monstre[moAE].nbCorps*300;
    monstre[moAE].espVie+=monstre[moAE].nbBecs*100;
    monstre[moAE].espVie+=monstre[moAE].nbJambes*70;
    monstre[moAE].espVie+=monstre[moAE].nbYeux*200;
  }
  if (monstre[moAE].type==3) {
    monstre[moAE].espVie+=monstre[moAE].nbPics*300;
    monstre[moAE].espVie+=monstre[moAE].nbQueues*100;
    monstre[moAE].espVie+=monstre[moAE].nbAiles*70;
    monstre[moAE].espVie+=monstre[moAE].nbYeuxC*200;
  }

  monstre[moAE].pasRemue();
  mAJmSSN();
  placeAuto();
  envoieSon(moAE);

}

public void SPays(int ledPays) {
  OscMessage myOscMessage = new OscMessage("/sonP");
  myOscMessage.add((float)pays[paysC].noiseV[beat]);
  myOscMessage.add((float)pays[paysC].noiseD[beat]);
  myOscMessage.add((float)pays[paysC].noiseF[beat]);
  myOscMessage.add((float)pays[paysC].noiseA[beat]);  
  myOscMessage.add((float)pays[paysC].sinV[beat]);
  myOscMessage.add((float)pays[paysC].sinD[beat]);
  myOscMessage.add((float)pays[paysC].sinF[beat]);
  myOscMessage.add((float)pays[paysC].sinA[beat]);  
  myOscMessage.add((int)ledPays);
  oscP5.send(myOscMessage, myRemoteLocation);      
}

public void lSA(int typeV, float xV, float tailleV, float lTotalV, float AltCilsV, float AltTentaculesV, float AltBrasV, float AltYeuxAV) {
  OscMessage myOscMessage = new OscMessage("/sonA");
  myOscMessage.add((float)xV);
  myOscMessage.add((float)tailleV);
  myOscMessage.add((float)lTotalV);
  myOscMessage.add((float)AltCilsV);
  myOscMessage.add((float)AltTentaculesV);
  myOscMessage.add((float)AltBrasV);
  myOscMessage.add((float)AltYeuxAV);
  oscP5.send(myOscMessage, myRemoteLocation);
}

public void lSB(int typeV, float xV, float tailleV, float BgtCorpsV, int BnbJambesV, float BltJambesV, float BltYeuxV, float[] tB, int BnbBecsV) {
  OscMessage myOscMessage = new OscMessage("/sonB");
  myOscMessage.add((float)xV);
  myOscMessage.add((float)tailleV);
  myOscMessage.add((int)BgtCorpsV);
  myOscMessage.add((int)BnbJambesV);
  myOscMessage.add((int)BltJambesV);    
  myOscMessage.add((float)BltYeuxV);
  for (int i=0;i<10;i++) {
    myOscMessage.add((float)tB[i]);
  }
  myOscMessage.add((int)BnbBecsV);    
  oscP5.send(myOscMessage, myRemoteLocation);
}

public void lSC(int typeV, float xV, float tailleV, float gTotalV, float[] lPics, float[] lQueues, float[] lAiles, float[] lYeuxC) {
  OscMessage myOscMessage = new OscMessage("/sonC");
  myOscMessage.add((float)xV);
  myOscMessage.add((float)tailleV);
  myOscMessage.add((float)gTotalV);
  for (int i=0;i<10;i++) {
    myOscMessage.add((float)lPics[i]);
  }
  for (int i=0;i<10;i++) {
    myOscMessage.add((float)lQueues[i]);
  }
  for (int i=0;i<10;i++) {
    myOscMessage.add((float)lAiles[i]);
  }
  for (int i=0;i<10;i++) {
    myOscMessage.add((float)lYeuxC[i]);
  }
  oscP5.send(myOscMessage, myRemoteLocation);
}

public void lSPB(float xV,float taille) {
  OscMessage myOscMessage = new OscMessage("/pasB");
  myOscMessage.add((float)xV);
  myOscMessage.add((float)taille);  
  oscP5.send(myOscMessage, myRemoteLocation);
}

public void sendGeneral() {
  OscMessage myOscMessage = new OscMessage("/general");
  myOscMessage.add(width);
  myOscMessage.add(height);
  myOscMessage.add(tailleMax);
  myOscMessage.add(paysC);
  myOscMessage.add(tOeuf);
  myOscMessage.add(0);
  myOscMessage.add(nbNotes);  
  oscP5.send(myOscMessage, myRemoteLocation);
  myOscMessage = new OscMessage("/paysNotes");
  for (int i=nbNotes-1;i>=0;i--) {
    myOscMessage.add(pays[paysC].freq[i]);
  }
  oscP5.send(myOscMessage, myRemoteLocation);  
}

public void eclosSon(float xV) {
  OscMessage myOscMessage = new OscMessage("/eclosSon");
  myOscMessage.add(xV);
  oscP5.send(myOscMessage, myRemoteLocation);    
}

public void lSO(float xV, float tailleV) {
  OscMessage myOscMessage = new OscMessage("/sonOeuf");
  myOscMessage.add(xV);
  myOscMessage.add(tailleV);  
  oscP5.send(myOscMessage, myRemoteLocation);      
}

public void sonDeprec(int vol) {
  OscMessage myOscMessage = new OscMessage("/sonDeprec");
  myOscMessage.add(vol);
  oscP5.send(myOscMessage, myRemoteLocation);        
}


public boolean hgDessus() {
  boolean value;
  if (phase==2 || phase==1) {
    boolean dessus=(mouseX>debModelx&&mouseY>debModely&&mouseX<sizModel+debModelx&&mouseY<sizModel+debModely);
    if (moAE!=-1) {
      if (monstre[moAE].type==2) {
        dessus=(mouseX>debModelx&&mouseY>debModely&&mouseX<sizModel+debModelx&&mouseY<sizModel+debModely-marSMembres);
      }
    }
    if(dessus){
      value=true;
    }
    else{
      value=false;
    }
  }
  else{
    value=false;    
  }
  if (cmMenuOn) {
    value=true;
  }
  return value;
}

public void loadPopup() {
  loadPixels();
  for (int i=0;i<width*height;i++) {
    fondPopUp.pixels[i]=color(hue(pixels[i]),saturation(pixels[i])/2,brightness(pixels[i])/2);
  }
  fondPopUp.updatePixels();
}

public void mouseMoved() {
  if (phase==3) {
    auClavier=false;
  }
}

public void mouseReleased() {
  entreIci=false;
  if (interditOn) {
    interditOn=false;
    sonDeprec(0);
  }
}

public void mousePressed() {
  if (phase==0) {    
    sourisPhaseA();
  }  
  else if (phase==1) {
    if (mouseX<debModelx) {
      sourisPhaseB();
    }
    else{
      sourisPhaseC();
    }
  }  
  else if (phase==3) {
    sourisPhaseD();
  }
  else if (phase==4) {
    sourisPhaseE();
  }
  else if (phase==5) {
    sourisPhaseF();
  }  
  else if (phase==6) {
    sourisPhaseG();
  }  
  else if (phase==7) {
    sourisPhaseH();
  }  
}

public void sourisPhaseF() {
  if (paysC!=-1) {
    phase=1;
    sendGeneral();
    entreIci=true;
  }
}

public void anime() {
  if (anime==true) {
    t1+=0.1f;
    t1=t1%TWO_PI;
  }
}


int truth=42;

boolean pasOn=false;//un bruit de pas en cette frame ?

boolean ledPas;
int quiPas;
boolean[] ledCri =new boolean[nbMonstres];

boolean afficheLeds=false;

boolean crisAct=true;
boolean pasAct=true;
boolean paysAct=true;

public void afficheLedsSon() {
  if (ledPays!=-1) {
    if (paysAct) {    
      SPays(ledPays);
    }
  }
  pushMatrix();
  if (afficheLeds) {  
    translate (40,60);
    stroke(100);
    fill(50);
    rect(-20,-20,nbMonSS*20+40,40);
  }
  for (int i=0;i<nbMonSS;i++) {
    if (ledCri[i]==true) {
      if (afficheLeds) {
        fill((float)i/nbMonSS*255,255,255);
      }
      envoieSon(mSSN[i]);
    }
    else{
      if (afficheLeds) {
        fill(0);
      }
    }
    if (afficheLeds) {
      ellipse(i*20,0,10,10);
    }
  }
  if (ledPas==true) {
    if (afficheLeds) {    
      fill(255);
    }
    float xV=(monstre[quiPas].x-camPos)/width;
    if (pasAct) {    
      lSPB(xV,monstre[quiPas].taille);
    }    
  }
  else{
    if (afficheLeds) {
      fill(0);
    }
  }  
  if (afficheLeds) {
    ellipse(nbMonSS*20,0,10,10);
  }
  popMatrix();
}

public void envoieSon(int mo) {
  int typeV=monstre[mo].type;
  if (typeV==1) {
    float xV=(monstre[mo].x-camPos)/width;
    float tailleV=monstre[mo].taille;
    float lTotalV=0;
    for (int i=0;i<nbBourses;i++) {
      lTotalV+=monstre[mo].bourseL[i];
    }
    float AltCilsV=0;
    for (int i=0;i<monstre[mo].nbCils;i++) {
      AltCilsV+=monstre[mo].cil[i].l;
    }    
    float AltTentaculesV=0;
    for (int i=0;i<monstre[mo].nbTentacules;i++) {
      AltTentaculesV+=monstre[mo].tentacule[i].l;
    }    
    AltTentaculesV+=1;
    float AltBrasV=0;
    for (int i=0;i<monstre[mo].nbBras;i++) {
      AltBrasV+=monstre[mo].bras[i].l;
    }    
    float AltYeuxAV=0;
    for (int i=0;i<monstre[mo].nbYeuxA;i++) {
      AltYeuxAV+=monstre[mo].oeilA[i].l;
    }    
    if (phase==1 || phase==5) {
      xV=0.5f;      
    }
    if (monstre[mo].taille>tOeuf) {
      if (crisAct) {
        lSA(typeV,xV,tailleV,lTotalV,AltCilsV,AltTentaculesV,AltBrasV,AltYeuxAV);
      }
    }    
    else{
      if (crisAct) {      
        lSO(xV,tailleV);
      }
    }
  }
  if (typeV==2) {
    float xV=(monstre[mo].x-camPos)/width;
    float tailleV=monstre[mo].taille;
    float BgtCorpsV=0;
    for (int i=0;i<monstre[mo].nbCorps;i++) {
      BgtCorpsV+=monstre[mo].corps[i].r;
    }
    int BnbJambesV=monstre[mo].nbJambes;
    float BltJambesV=0;
    for (int i=0;i<monstre[mo].nbJambes;i++) {
      BltJambesV+=monstre[mo].jambe[i].lJ;
    }
    float BltYeuxV=0;
    for (int i=0;i<monstre[mo].nbYeux;i++) {
      BltYeuxV+=monstre[mo].oeil[i].r;
    }
    float[] tB=new float[nbMembresMax];
    for (int i=0;i<nbMembresMax;i++) {
      if (i<monstre[mo].nbBecs) {
        tB[i]=monstre[mo].bec[i].l;
      }
      else{
        tB[i]=0;
      }
    }
    int BnbBecsV=monstre[mo].nbBecs;
    if (phase==1 || phase==5) {
      xV=0.5f;      
    }
    if (monstre[mo].taille>tOeuf) {
      if (crisAct) {      
        lSB(typeV,xV,tailleV,BgtCorpsV,BnbJambesV,BltJambesV,BltYeuxV,tB,BnbBecsV);
      }
    }
    else{
      if (crisAct) {      
        lSO(xV,tailleV);      
      }
    }
  }
  if (typeV==3) {
    float xV=(monstre[mo].x-camPos)/width;
    float tailleV=monstre[mo].taille;
    float gTotalV=0;
    for (int i=0;i<nbVertebres;i++) {
      gTotalV+=monstre[mo].gVert[i];
    }
    float[] lPics=new float[nbMembresMax];
    for (int i=0;i<nbMembresMax;i++) {
      if (monstre[mo].nbPics>0) {
        lPics[i]=monstre[mo].pic[i%monstre[mo].nbPics].l;
      }
      else{
        lPics[i]=5;
      }
    }
    float[] lQueues=new float[nbMembresMax];
    for (int i=0;i<nbMembresMax;i++) {
      if (monstre[mo].nbQueues>0) {
        lQueues[i]=monstre[mo].queue[i%monstre[mo].nbQueues].l;
      }
      else{
        lQueues[i]=5;
      }
    }
    float[] lAiles=new float[nbMembresMax];
    for (int i=0;i<nbMembresMax;i++) {
      if (monstre[mo].nbAiles>0) {
        lAiles[i]=monstre[mo].aile[i%monstre[mo].nbAiles].l;
      }
      else{
        lAiles[i]=5;
      }
    }
    float[] lYeuxC=new float[nbMembresMax];
    for (int i=0;i<nbMembresMax;i++) {
      if (monstre[mo].nbYeuxC>0) {
        lYeuxC[i]=monstre[mo].oeilC[i%monstre[mo].nbYeuxC].l;
      }
      else{
        lYeuxC[i]=75;
      }
    }
    if (phase==1 || phase==5) {
      xV=0.5f;      
    }    
    if (monstre[mo].taille>tOeuf) {
      if (crisAct) {      
        lSC(typeV,xV,tailleV,gTotalV,lPics,lQueues,lAiles,lYeuxC);
      }
    }
    else{
      if (crisAct) {      
        lSO(xV,tailleV);      
      }
    }
  }
}

float xPrev2;
boolean tryADeprecat=false;
boolean[] fullMembred= new boolean[4];

public void cmMenu() {
  if (cmMenuOn==true) {
    stroke(30,80,30);
    pushMatrix();
    xPrev=constrain(xPrev,debModelx+20,debModelx+sizModel-20);
    xPrev2=xPrev;
    if (monstre[moAE].type==3 && mouseX<debModelx+mCX) {
      xPrev2=symX(xPrev);
    }
    translate(xPrev2,yPrev);
    colorMM(-20,-20);
    rect(-20,-20,20,20);
    colorMM(0,-20);
    rect(0,-20,20,20);
    colorMM(-20,0);
    rect(-20,0,20,20);
    colorMM(0,0);
    rect(0,0,20,20);
    line(0,-20,0,20);
    line(-20,0,20,0);
    noStroke();
    fill(0);
    pushMatrix();//corps
    translate(-10,-10);
    if (monstre[moAE].type==1) {
      triangle(-5,5,5,5,0,-5);
    }
    if (monstre[moAE].type==2) {
      ellipse(0,0,15,15);
    }
    if (monstre[moAE].type==3) {
      quad(-6,7,6,7,3,-7,-3,-7);
    }
    if (monstre[moAE].type==1) {    
      if (monstre[moAE].nbCils==10) {
        croix();
        fullMembred[0]=true;
      }
      else{
        fullMembred[0]=false;      
      }
    }
    if (monstre[moAE].type==2) {    
      if (monstre[moAE].nbCorps==10) {
        croix();
        fullMembred[0]=true;      
      }
      else{
        fullMembred[0]=false;      
      }
    }
    if (monstre[moAE].type==3) {    
      if (monstre[moAE].nbPics==10) {     
        croix();
        fullMembred[0]=true;      
      }
      else{
        fullMembred[0]=false;      
      }
    }
    if (tryADeprecat) {
      croix();  
    }
    popMatrix();
    pushMatrix();//jambe    
    translate(10,-10);    
    if (monstre[moAE].type==1) {    
      ellipse(5,-5,6,6);
      ellipse(0,0,6,6);      
      ellipse(-5,5,6,6);
    }
    if (monstre[moAE].type==2) {    
      quad(-5,-5,-5,0,0,0,5,-5);
      triangle(0,0,5,-5,0,8);
    }
    if (monstre[moAE].type==3) {    
      ellipse(5,-5,6,6);
      ellipse(0,0,6,6);      
      ellipse(-5,5,6,6);
    } 
    if (monstre[moAE].type==1) {    
      if (monstre[moAE].nbTentacules==10) {
        croix();
        fullMembred[1]=true;       
      }
      else{
        fullMembred[1]=false;      
      }
    }
    if (monstre[moAE].type==2) {    
      if (monstre[moAE].nbJambes==10 && monstre[moAE].type==2) {
        croix();
        fullMembred[1]=true;             
      }    
      else{
        fullMembred[1]=false;      
      }
    }
    if (monstre[moAE].type==3) {    
      if (monstre[moAE].nbQueues==10) {
        croix();
        fullMembred[1]=true;             
      }
      else{
        fullMembred[1]=false;      
      }
    }
    if (tryADeprecat) {
      croix();
    }
    popMatrix();
    pushMatrix();//bec
    translate(-10,10);    
    if (monstre[moAE].type==1) {     
      triangle(5,-5,-5,-5,5,0);
    }
    if (monstre[moAE].type==2) {     
      triangle(5,-5,-5,-5,5,0);      
      triangle(5,0,-5,5,5,5);
    }
    if (monstre[moAE].type==3) {     
      triangle(5,0,-5,5,5,5);
    }    
    if (monstre[moAE].type==1) {    
      if (monstre[moAE].nbBras==10) {
        croix();
        fullMembred[2]=true;             
      }
      else{
        fullMembred[2]=false;      
      }    
    }
    if (monstre[moAE].type==2) {    
      if (monstre[moAE].nbBecs==10) {
        croix();
        fullMembred[2]=true;      
      }    
      else{
        fullMembred[2]=false;      
      }    
    }
    if (monstre[moAE].type==3) {
      if (monstre[moAE].nbAiles==10 && monstre[moAE].type==3) {
        croix();
        fullMembred[2]=true;      
      }
      else{
        fullMembred[2]=false;      
      }    
    }
    if (tryADeprecat) {
      croix();
    }
    popMatrix();
    pushMatrix();//oeil
    translate(10,10);
    ellipse(0,0,15,15);
    fill(255);
    ellipse(0,0,10,10);
    if (monstre[moAE].type==1) {    
      if (monstre[moAE].nbYeuxA==10) {
        croix();
        fullMembred[3]=true;       
      }    
      else{
        fullMembred[3]=false;      
      }
    }
    if (monstre[moAE].type==2) {
      if (monstre[moAE].nbYeux==10) {
        croix();
        fullMembred[3]=true;             
      }    
      else{
        fullMembred[3]=false;      
      }  
    }
    if (monstre[moAE].type==3) {
      if (monstre[moAE].nbYeuxC==10) {
        croix();
        fullMembred[3]=true;             
      }
      else{
        fullMembred[3]=false;      
      }
    }
    popMatrix();
    popMatrix();
  }
  else {
    tryADeprecat=false;
  }
}

public void croix() {
  stroke(0,255,255);
  line(-5,-5,5,5);
  line(5,-5,-5,5);  
  noStroke();
}

public void colorMM(float x, float y) {
  if (dansC(x+xPrev2,y+yPrev,x+20+xPrev2,y+20+yPrev)) {
    fill(200,60,200);
  }
  else {
    fill(200,60,80);
  }
}

public boolean dansC(float x,float y,float x2,float y2) {
  if (mouseX>x && mouseX<x2 &&mouseY>y && mouseY<y2 ) {
    return true;
  }
  else{
    return false;      
  }
}

public void mAJLignePrev() {
  if (mouseX>debModelx) {
    if (moAE!=-1) {
      if (!cmMenuOn) {
        att=rechercheCorpsPres();
        if (monstre[moAE].type==1) {
          if (att>=0 && att<nbBourses) {
            cPresX=monstre[moAE].xRBour[att]+mCX+debModelx;
            cPresY=monstre[moAE].yRBour[att]+mCY+debModely;
          }
        }
        if (monstre[moAE].type==2) {
          if (att>=0 && att<nbMembresMax) {
            cPresX=monstre[moAE].corps[att].xR+mCX+debModelx;
            cPresY=monstre[moAE].corps[att].yR+mCY+debModely;
          }
        }
        if (monstre[moAE].type==3) {
          if (att>=0 && att<nbVertebres) {
            cPresX=monstre[moAE].xRVert[att]+mCX+debModelx;
            cPresY=monstre[moAE].yRVert[att]+mCY+debModely;
          }
        }
      }
    }
  }
}

public float valeurSet(int dep, int att, float mini, float maxi) {
  float rapp=longueur(sizModel/2,sizModel/2,0,0);
  float xAtt=monstre[dep].corps[att].xR+mCX+debModelx;
  float yAtt=monstre[dep].corps[att].yR+mCY+debModely;
  controlAPrev=longueur(xPrev,yPrev,xAtt,yAtt)/rapp;
  return mini+(controlAPrev*(maxi-mini));
}

public void elementsPreview() {
  if (deprecated()) {
    stroke(0,255,255);
  }
  else{
    stroke(100,255,255);    
  }
  if (cmMenuOn) {
    if (tryADeprecat) {
      stroke(0,255,255);
    }
    else{
      stroke(100,255,255);    
    }    
  }
  noFill();
  if (hgDessus()==true) {
    ellipse(xPrev,yPrev,10,10);//cible rouge
    line(xPrev-10,yPrev,xPrev+10,yPrev);
    line(xPrev,yPrev-10,xPrev,yPrev+10);
    line(xPrev,yPrev,cPresX,cPresY);//trait de liaison rouge
    if (monstre[moAE].type==3) {//de l'autre c\u00f4t\u00e9
      ellipse(symX(xPrev),yPrev,10,10);//cible rouge
      line(symX(xPrev-10),yPrev,symX(xPrev+10),yPrev);
      line(symX(xPrev),yPrev-10,symX(xPrev),yPrev+10);
      line(symX(xPrev),yPrev,symX(cPresX),cPresY);//trait de liaison rouge
    }    
  }
  if (monstre[moAE].type==2) {//les corps en rouge
    if (teShapeOn) {
      noFill();
      stroke(0,255,255);
      ellipse(teShapeX,teShapeY,teShapeS*2,teShapeS*2);
      noStroke();
    }
  }  
}

int att;

public int rechercheCorpsPres() {
  int att=0;
  if (monstre[moAE].type==1) {
    att=0;
    float tmpLong=sizModel;
    for (int i=0;i<nbBourses;i++) {
      if (longueur(mouseX-debModelx-mCX,mouseY-debModely-mCY,monstre[moAE].bourseL[i]*cos(monstre[moAE].bourseR[i]),monstre[moAE].bourseL[i]*sin(monstre[moAE].bourseR[i]))<tmpLong) {
        tmpLong=longueur(mouseX-debModelx-mCX,mouseY-debModely-mCY,monstre[moAE].bourseL[i]*cos(monstre[moAE].bourseR[i]),monstre[moAE].bourseL[i]*sin(monstre[moAE].bourseR[i]));
        att=i;
      }
    }
  }  
  if (monstre[moAE].type==2) {
    float longueurMin=sizModel;
    for (int i=0;i<monstre[moAE].nbCorps;i++) {
      float proxi=longueur(monstre[moAE].corps[i].xR+mCX+debModelx,monstre[moAE].corps[i].yR+mCY+debModely,mouseX,mouseY);
      if (proxi<longueurMin) {
        longueurMin=proxi;
        att=i;
      }
    }
  }
  if (monstre[moAE].type==3) {
    //att=constrain(floor((mouseY-debModel)*nbVertebres/sizModel),0,nbVertebres-2);//avant, c'\u00e9tait comme \u00e7a
    att=0;
    float tmpLong=sizModel;
    for (int i=0;i<nbVertebres;i++) {
      float actLong=longueur(mouseX2()-debModelx-mCX,mouseY-debModely-mCY,monstre[moAE].xRVert[i],monstre[moAE].yRVert[i]);
      if (actLong<tmpLong) {
        att=i;
        tmpLong=actLong;
      }
    }
  }  
  return att;
}


  static public void main(String args[]) {
    PApplet.main(new String[] { "betesnoires" });
  }
}
